/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.service;

import com.xforceplus.dao.AutoscanRecordDao;
import com.xforceplus.entity.AutoscanRecord;
import com.xforceplus.route.constants.AutoscanStatus;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AutoscanRecordService {
    private static final Logger log = LoggerFactory.getLogger(AutoscanRecordService.class);
    private static final String REDIS_PREFIX = "XF_AUTOSCAN_";
    private final AutoscanRecordDao autoscanRecordDao;
    private final RedisTemplate<String, String> redisTemplate;

    public AutoscanRecordService(AutoscanRecordDao autoscanRecordDao, RedisTemplate<String, String> redisTemplate) {
        this.autoscanRecordDao = autoscanRecordDao;
        this.redisTemplate = redisTemplate;
    }

    @Transactional(rollbackFor={Exception.class})
    public AutoscanRecord save(String routeIds, Boolean isServicePackage) {
        String key = REDIS_PREFIX + routeIds.trim().replace(",", "_");
        boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"exists", 10L, TimeUnit.MINUTES);
        AutoscanRecord autoscanRecord = new AutoscanRecord();
        autoscanRecord.setRouteIds(routeIds);
        autoscanRecord.setIsServicePackage(isServicePackage);
        if (result) {
            autoscanRecord.setStatus(AutoscanStatus.CREATED);
        } else {
            autoscanRecord.setStatus(AutoscanStatus.INVALID);
        }
        autoscanRecord.setCreateTime(new Date());
        autoscanRecord.setUpdateTime(new Date());
        return (AutoscanRecord)this.autoscanRecordDao.saveAndFlush((Object)autoscanRecord);
    }

    @Transactional(rollbackFor={Exception.class})
    public AutoscanRecord updateStatus(AutoscanRecord autoscanRecord) {
        autoscanRecord.setUpdateTime(new Date());
        return (AutoscanRecord)this.autoscanRecordDao.saveAndFlush((Object)autoscanRecord);
    }
}

