/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.service;

import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.entity.Resource;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.entity.Route;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.route.dto.ResourceAndPathDto;
import com.xforceplus.route.service.ServiceApiService;
import com.xforceplus.tenant.security.autoscan.model.AuthorizationInfo;
import com.xforceplus.tenant.security.autoscan.model.AuthorizationUri;
import com.xforceplus.tenant.security.autoscan.model.AutoScanBody;
import com.xforceplus.tenant.security.autoscan.model.ResourceItem;
import com.xforceplus.utils.ApiUtils;
import com.xforceplus.utils.RouteUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.server.PathContainer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Service
public class ResourceAndPathService {
    private static final Logger log = LoggerFactory.getLogger(ResourceAndPathService.class);
    private final ServiceApiDao serviceApiDao;
    private final ResourceDao resourceDao;
    private final ServiceApiService serviceApiService;
    private final ResourceApiRelDao resourceApiRelDao;
    private static final String operateUserName = "\u81ea\u52a8\u626b\u63cf";
    private static final PathPatternParser pathPatternParser = PathPatternParser.defaultInstance;

    public ResourceAndPathService(ServiceApiDao serviceApiDao, ResourceDao resourceDao, ServiceApiService serviceApiService, ResourceApiRelDao resourceApiRelDao) {
        this.serviceApiDao = serviceApiDao;
        this.resourceDao = resourceDao;
        this.serviceApiService = serviceApiService;
        this.resourceApiRelDao = resourceApiRelDao;
    }

    @Transactional(rollbackFor={Exception.class})
    public void initItem(Route route, Boolean isServicePackage, AutoScanBody autoScanBody, List<Route> sortedRoutes) {
        List<ResourceAndPathDto> list = this.fetchResource(route, autoScanBody, sortedRoutes);
        this.saveResourceWithParent(route, isServicePackage, null, autoScanBody.getResources());
        ArrayList<ServiceApi> serviceApis = new ArrayList<ServiceApi>();
        this.saveResourceAndPath(list, serviceApis, route, isServicePackage);
        this.deleteServiceApi(list, serviceApis, route);
    }

    private void saveResourceWithParent(Route route, Boolean isServicePackage, Long parentId, List<ResourceItem> resources) {
        if (CollectionUtils.isEmpty(resources)) {
            log.info("resources is empty, return");
            return;
        }
        for (ResourceItem resourceItem : resources) {
            List list = this.resourceDao.findAll((Specification & Serializable)(root, query, builder) -> {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                predicates.add(builder.equal((Expression)root.get("resourceCode"), (Object)resourceItem.getResourceCode()));
                if (route.getAppId() != null && route.getAppId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get("appId"), (Object)route.getAppId()));
                }
                query.where(predicates.toArray(new Predicate[0]));
                return query.getRestriction();
            });
            Resource sysResource = CollectionUtils.isNotEmpty((Collection)list) ? (Resource)list.get(0) : new Resource();
            this.fillResourceData(route, resourceItem.getResourceName(), resourceItem.getResourceCode(), sysResource, isServicePackage);
            if (parentId != null && parentId > 0L) {
                sysResource.setParentId(parentId);
            }
            this.resourceDao.saveAndFlush((Object)sysResource);
        }
    }

    private void deleteServiceApi(List<ResourceAndPathDto> list, List<ServiceApi> insertServiceApis, Route route) {
        List existServiceApis = this.serviceApiDao.findAll((Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("routeId"), (Object)route.getRouteId()));
            query.where(predicates.toArray(new Predicate[0]));
            return query.getRestriction();
        });
        if (CollectionUtils.isEmpty((Collection)existServiceApis)) {
            return;
        }
        Set remainServiceApiIds = insertServiceApis.stream().map(ServiceApi::getServiceApiId).collect(Collectors.toSet());
        Set<String> hashSet = this.getHashset(list);
        for (ServiceApi serviceApi : existServiceApis) {
            String hash = ApiUtils.hash((String)serviceApi.getServiceApiUrl(), (String)serviceApi.getRequestMethod().name(), (Long)serviceApi.getRouteId());
            if (serviceApi.getManual() != null && serviceApi.getManual().booleanValue() && hashSet.contains(hash) || remainServiceApiIds.contains(serviceApi.getServiceApiId())) continue;
            this.serviceApiDao.deleteById(serviceApi.getServiceApiId());
            List resourceApiRels = this.resourceApiRelDao.findByServiceApiId(serviceApi.getServiceApiId());
            for (ResourceApiRel resourceApiRel : resourceApiRels) {
                this.resourceApiRelDao.deleteById(resourceApiRel.getId());
                List remainResourceApiRels = this.resourceApiRelDao.findByResourceIdAndNotServiceApiId(resourceApiRel.getResourceId().longValue(), resourceApiRel.getServiceApiId().longValue());
                if (!remainResourceApiRels.isEmpty()) continue;
                this.resourceDao.deleteById(resourceApiRel.getResourceId());
            }
        }
    }

    public Set<String> getHashset(List<ResourceAndPathDto> list) {
        HashSet<String> hashset = new HashSet<String>(list.size());
        for (ResourceAndPathDto resourceAndPathDto : list) {
            String hash = ApiUtils.hash((String)resourceAndPathDto.getApiUrl(), (String)resourceAndPathDto.getRequestMethod(), (Long)resourceAndPathDto.getRouteId());
            hashset.add(hash);
        }
        return hashset;
    }

    public List<ResourceAndPathDto> fetchResource(Route route, AutoScanBody autoScanBody, List<Route> sortedRoutes) {
        String createUserId = "";
        Map aaMap = autoScanBody.getAaMap();
        log.info("\u83b7\u53d6request_mapping size={}", (Object)aaMap.size());
        ArrayList<ResourceAndPathDto> list = new ArrayList<ResourceAndPathDto>(aaMap.size());
        for (Map.Entry entry : aaMap.entrySet()) {
            AuthorizationUri authorizationUri = (AuthorizationUri)entry.getKey();
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)entry.getValue();
            String apiPath = authorizationUri.getPath();
            Route bestMatchRoute = this.bestMatchRoute(apiPath, sortedRoutes);
            if (bestMatchRoute == null) {
                log.debug("\u6700\u5339\u914d\u8def\u7531(bestMatchRoute) == null, \u8df3\u8fc7");
                continue;
            }
            if (!route.getRouteId().equals(bestMatchRoute.getRouteId())) {
                log.debug("\u5f53\u524d\u8def\u7531(routeId:{})\u548c\u6700\u5339\u914d\u8def\u7531(routeId:{})\u4e0d\u4e00\u81f4", (Object)route.getRouteId(), (Object)bestMatchRoute.getRouteId());
                continue;
            }
            boolean hasAnyAuthorizedDefinition = false;
            if (authorizationInfo != null) {
                boolean bl = hasAnyAuthorizedDefinition = authorizationInfo.getSkipAuthentication() != false || authorizationInfo.getSkipAuthorization() != false || authorizationInfo.getTimeout() != null || authorizationInfo.getResources() != null && !authorizationInfo.getResources().isEmpty();
            }
            if (!hasAnyAuthorizedDefinition) {
                log.debug("api\u5730\u5740(path:{}, method:{})\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55@AuthorizedDefinition,\u8df3\u8fc7", (Object)apiPath, (Object)authorizationUri.getMethod());
                continue;
            }
            ResourceAndPathDto item = new ResourceAndPathDto();
            item.setAppId(route.getAppId());
            item.setApiUrl(apiPath);
            item.setRequestMethod(authorizationUri.getMethod());
            item.setName(authorizationInfo.getName());
            item.setApiPath(authorizationInfo.getMethodName());
            item.setSkipAuthentication(authorizationInfo.getSkipAuthentication());
            item.setSkipAuthorization(authorizationInfo.getSkipAuthorization());
            item.setSkipTrail(Objects.isNull(authorizationInfo.getSkipTrail()) ? Boolean.TRUE : authorizationInfo.getSkipTrail());
            item.setCreateUserId(createUserId);
            item.setRouteId(route.getRouteId());
            if (authorizationInfo.getResources() != null && !authorizationInfo.getResources().isEmpty()) {
                item.setResourceCodes(authorizationInfo.getResources());
            }
            list.add(item);
        }
        return list;
    }

    private Route bestMatchRoute(String apiPath, List<Route> sortedRoutes) {
        Route bestMatchRoute = null;
        apiPath = RouteUtils.reRenderPath((String)apiPath);
        apiPath = StringUtils.prependIfMissing((String)apiPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        PathContainer apiPathContainer = PathContainer.parsePath((String)apiPath);
        for (Route route : sortedRoutes) {
            String routeDestPath = UriComponentsBuilder.fromHttpUrl((String)route.getUrl()).build().getPath();
            String routePostPath = StringUtils.prependIfMissing((String)routeDestPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            if (routePostPath == null) {
                log.warn("\u8def\u7531(routeId:{})\u7684 postPath == null, continue", (Object)route.getRouteId());
                continue;
            }
            PathPattern postPathPattern = pathPatternParser.parse(routePostPath = RouteUtils.reRenderPath((String)routePostPath));
            PathPattern.PathRemainingMatchInfo remainingMatchInfo = postPathPattern.matchStartOfPath(apiPathContainer);
            if (remainingMatchInfo == null) {
                log.debug("api\u5730\u5740({})\u548c\u8def\u7531(routeId:{})\u76ee\u7684\u5730\u5740({})\u4e0d\u5339\u914d,\u8df3\u8fc7", new Object[]{apiPath, route.getRouteId(), routeDestPath});
                continue;
            }
            String routePrePath = route.getPath();
            routePrePath = StringUtils.prependIfMissing((String)routePrePath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            if (StringUtils.startsWith((CharSequence)apiPath, (CharSequence)(routePrePath = RouteUtils.reRenderPath((String)routePrePath)))) {
                bestMatchRoute = route;
                break;
            }
            if (bestMatchRoute != null) continue;
            bestMatchRoute = route;
        }
        return bestMatchRoute;
    }

    private void saveResourceAndPath(List<ResourceAndPathDto> list, List<ServiceApi> serviceApis, Route route, Boolean isServicePackage) {
        String pathUri = UriComponentsBuilder.fromHttpUrl((String)route.getUrl()).build().getPath();
        boolean isExactMatch = route.getIsExactMatch();
        for (ResourceAndPathDto item : list) {
            if (!StringUtils.isNotBlank((CharSequence)item.getApiUrl()) || !StringUtils.isNotBlank((CharSequence)item.getRequestMethod())) continue;
            boolean matchPath = this.isMatchPath(pathUri, item, isExactMatch);
            if (!matchPath) {
                log.info("\u63a5\u53e3\u65e0\u6cd5\u901a\u8fc7\u8be5\u8def\u7531\u6620\u5c04, route.path: {}, service-api.url: {}", (Object)route.getUrl(), (Object)item.getApiUrl());
                continue;
            }
            ServiceApi serviceApi = this.saveServiceApi(item, route);
            serviceApis.add(serviceApi);
            if (item.getResourceCodes() == null || item.getResourceCodes().isEmpty()) continue;
            item.getResourceCodes().forEach(resCode -> {
                Resource resource;
                if (StringUtils.isNotBlank((CharSequence)resCode) && (resource = this.saveResource(route, (String)resCode, isServicePackage)) != null) {
                    this.serviceApiService.saveResourceApiRel(resource.getResourceId(), serviceApi.getServiceApiId(), operateUserName);
                }
            });
        }
    }

    private boolean isMatchPath(String pathUri, ResourceAndPathDto item, boolean isExactMatch) {
        if (!StringUtils.startsWith((CharSequence)pathUri, (CharSequence)"/")) {
            pathUri = "/" + pathUri;
        }
        String pattern = isExactMatch ? pathUri : (StringUtils.equals((CharSequence)"/", (CharSequence)pathUri) ? "/**" : pathUri + "/**");
        PathPatternParser pathPatternParser = new PathPatternParser();
        return pathPatternParser.parse(pattern).matches(PathContainer.parsePath((String)item.getApiUrl()));
    }

    public Resource saveResource(Route route, String resourceCode, Boolean isServicePackage) {
        List list = this.resourceDao.findAll((Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("resourceCode"), (Object)resourceCode));
            if (route.getAppId() != null && route.getAppId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("appId"), (Object)route.getAppId()));
            }
            query.where(predicates.toArray(new Predicate[0]));
            return query.getRestriction();
        });
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Resource sysResource = (Resource)list.get(0);
            this.fillResourceData(route, null, resourceCode, sysResource, isServicePackage);
            this.resourceDao.saveAndFlush((Object)sysResource);
            return sysResource;
        }
        return null;
    }

    private ServiceApi saveServiceApi(ResourceAndPathDto item, Route route) {
        ServiceApi serviceApi;
        String hash = ApiUtils.hash((String)item.getApiUrl(), (String)item.getRequestMethod(), (Long)route.getRouteId());
        List serviceApis = this.serviceApiDao.findByHash(hash);
        if (CollectionUtils.isNotEmpty((Collection)serviceApis)) {
            serviceApi = (ServiceApi)serviceApis.get(0);
        } else {
            serviceApi = new ServiceApi();
            serviceApi.setHash(hash);
        }
        this.buildServiceApi(route, item, serviceApi);
        this.serviceApiDao.saveAndFlush((Object)serviceApi);
        return serviceApi;
    }

    private void buildServiceApi(Route route, ResourceAndPathDto item, ServiceApi serviceApi) {
        serviceApi.setServiceApiPath(item.getApiPath());
        serviceApi.setServiceApiUrl(item.getApiUrl());
        serviceApi.setRequestMethod(RequestMethod.valueOf((String)item.getRequestMethod()));
        serviceApi.setAppId(Long.valueOf(route.getAppId() == null ? 1L : route.getAppId()));
        if (StringUtils.isNotBlank((CharSequence)item.getName())) {
            serviceApi.setServiceApiName(item.getName());
        } else {
            serviceApi.setServiceApiName("\u6ca1\u6709\u540d\u79f0");
        }
        serviceApi.setRouteId(item.getRouteId());
        serviceApi.setSkipAuthentication(item.getSkipAuthentication());
        serviceApi.setSkipAuthorization(item.getSkipAuthorization());
        serviceApi.setStatus(Integer.valueOf(1));
        Date now = Calendar.getInstance().getTime();
        if (serviceApi.getServiceApiId() == null) {
            serviceApi.setCreaterName(operateUserName);
            serviceApi.setCreateTime(now);
        }
        serviceApi.setUpdaterName(operateUserName);
        serviceApi.setUpdateTime(now);
    }

    private void fillResourceData(Route route, String resourceName, String resourceCode, Resource sysResource, Boolean isServicePackage) {
        sysResource.setAppId(Long.valueOf(route.getAppId() == null ? 1L : route.getAppId()));
        sysResource.setResourceCode(resourceCode);
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            sysResource.setResourceName(resourceName);
        }
        if (isServicePackage != null && !isServicePackage.booleanValue()) {
            sysResource.setIsServicePackage(Boolean.valueOf(false));
        } else if (sysResource.getResourceId() == null || StringUtils.equals((CharSequence)sysResource.getCreaterName(), (CharSequence)operateUserName)) {
            sysResource.setIsServicePackage(Boolean.valueOf(true));
        }
        if (sysResource.getResourceId() != null) {
            sysResource.setUpdaterName(operateUserName);
        } else {
            sysResource.setResourcePlatform(Integer.valueOf(0));
            sysResource.setResourceType(Integer.valueOf(0));
            sysResource.setStatus(Integer.valueOf(1));
            sysResource.setParentId(Long.valueOf(0L));
            sysResource.setCreaterName(operateUserName);
            sysResource.setCreateTime(new Date());
        }
    }
}

