/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.service;

import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.entity.Resource;
import com.xforceplus.query.ResourceQueryHelper;
import com.xforceplus.route.api.common.model.ResourceModel;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ResourceService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceService.class);
    private final ResourceDao resourceDao;
    private final ResourceApiRelDao resourceApiRelDao;
    private final ServiceApiDao serviceApiDao;
    private final RedisTemplate redisTemplate;

    public ResourceService(ResourceDao resourceDao, ResourceApiRelDao resourceApiRelDao, ServiceApiDao serviceApiDao, RedisTemplate redisTemplate) {
        this.resourceDao = resourceDao;
        this.resourceApiRelDao = resourceApiRelDao;
        this.serviceApiDao = serviceApiDao;
        this.redisTemplate = redisTemplate;
    }

    public Page<Resource> page(ResourceModel.Request.Query query, Pageable pageable) {
        Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
        Page page = this.resourceDao.findAll(specification, pageable, EntityGraphs.named((String)"Resource.graph"));
        if (!query.isFlat() && !page.isEmpty()) {
            for (Resource resource : page) {
                List children = this.resourceDao.findByParentId(resource.getResourceId().longValue());
                if (CollectionUtils.isEmpty((Collection)children)) {
                    resource.setChildren(null);
                    continue;
                }
                resource.setChildren(children);
            }
        }
        return page;
    }

    public Page<Resource> page(Specification<Resource> specification, Pageable pageable) {
        Page page = this.resourceDao.findAll(specification, pageable, EntityGraphs.named((String)"Resource.graph"));
        return page;
    }

    public List<Resource> list(ResourceModel.Request.Query query, Sort sort) {
        Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
        List list = this.resourceDao.findAll(specification, sort, EntityGraphs.named((String)"Resource.graph"));
        return list;
    }

    public List<Resource> list(Specification<Resource> specification, Sort sort) {
        return this.resourceDao.findAll(specification, sort, EntityGraphs.named((String)"Resource.graph"));
    }

    public Optional<Resource> findOne(ResourceModel.Request.Query query) {
        Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
        return this.resourceDao.findOne(specification);
    }

    public long count(ResourceModel.Request.Query query) {
        Specification specification = ResourceQueryHelper.querySpecification((ResourceModel.Request.Query)query);
        return this.resourceDao.count(specification);
    }
}

