/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.service;

import com.google.common.collect.Lists;
import com.xforceplus.dao.RouteApplyDao;
import com.xforceplus.entity.RouteApply;
import com.xforceplus.route.service.RouteService;
import io.geewit.core.utils.reflection.BeanUtils;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RouteApplyService {
    private final RouteApplyDao routeApplyDao;
    private final RouteService routeService;

    public RouteApplyService(RouteApplyDao routeApplyDao, RouteService routeService) {
        this.routeApplyDao = routeApplyDao;
        this.routeService = routeService;
    }

    @Transactional(rollbackFor={Exception.class})
    public RouteApply create(RouteApply route) {
        route.setRouteApplyId(null);
        route.setStatus(Integer.valueOf(1));
        return (RouteApply)this.routeApplyDao.save((Object)route);
    }

    @Transactional(rollbackFor={Exception.class})
    public RouteApply update(Long id, RouteApply route) {
        RouteApply existRouteApply = (RouteApply)this.routeApplyDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u8be5\u8def\u7531\u7533\u8bf7(" + id + ")"));
        if (existRouteApply.getStatus() == null || existRouteApply.getStatus() != 1) {
            throw new IllegalArgumentException("\u8be5\u7533\u8bf7\u8bb0\u5f55\u5df2\u7ecf\u53d7\u7406\uff0c\u65e0\u6cd5\u66f4\u6539\u3002");
        }
        BeanUtils.copyProperties((Object)route, (Object)existRouteApply);
        return (RouteApply)this.routeApplyDao.save((Object)existRouteApply);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Long routeApplyId) {
        this.routeApplyDao.deleteById((Object)routeApplyId);
    }

    public List<RouteApply> findAll(Sort sort) {
        return Lists.newArrayList((Iterable)this.routeApplyDao.findAll(sort));
    }

    public Page<RouteApply> findAll(Pageable pageable) {
        return this.routeApplyDao.findAll(pageable);
    }

    @Transactional(rollbackFor={Exception.class})
    public RouteApply changeStatus(Long id, Integer status) {
        RouteApply existRouteApply = (RouteApply)this.routeApplyDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u8be5\u8def\u7531\u7533\u8bf7(" + id + ")"));
        if (existRouteApply.getStatus() == null || existRouteApply.getStatus() != 1) {
            throw new IllegalArgumentException("\u8be5\u7533\u8bf7\u8bb0\u5f55\u5df2\u7ecf\u53d7\u7406\u3002");
        }
        if (status == null || status != 2 && status != 3) {
            throw new IllegalArgumentException("\u4f20\u5165\u72b6\u6001\u6709\u8bef\u3002");
        }
        existRouteApply.setStatus(status);
        if (existRouteApply.getStatus() == 2) {
            this.routeService.createByRouteApply(existRouteApply);
        }
        return (RouteApply)this.routeApplyDao.save((Object)existRouteApply);
    }

    public long countByHash(String hash) {
        return this.routeApplyDao.countByHash(hash);
    }
}

