/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xforceplus.dao.RouteDao;
import com.xforceplus.entity.Route;
import com.xforceplus.entity.RouteApply;
import com.xforceplus.query.RouteQueryHelper;
import com.xforceplus.route.api.common.model.RouteModel;
import com.xforceplus.route.listener.MessagePublisher;
import com.xforceplus.route.service.ResourceAndPathService;
import com.xforceplus.tenant.security.autoscan.model.AuthorizationInfo;
import com.xforceplus.tenant.security.autoscan.model.AuthorizationUri;
import com.xforceplus.tenant.security.autoscan.model.AutoScanBody;
import com.xforceplus.utils.RouteUtils;
import io.geewit.core.exception.ProcessedException;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.utils.uuid.UUIDUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Service
public class RouteService {
    private static final Logger logger = LoggerFactory.getLogger(RouteService.class);
    private final RouteDao routeDao;
    private final MessagePublisher messagePublisher;
    private final RedisTemplate redisTemplate;
    private final ResourceAndPathService resourceAndPathService;

    public RouteService(RouteDao routeDao, MessagePublisher messagePublisher, RedisTemplate redisTemplate, ResourceAndPathService resourceAndPathService) {
        this.routeDao = routeDao;
        this.messagePublisher = messagePublisher;
        this.redisTemplate = redisTemplate;
        this.resourceAndPathService = resourceAndPathService;
    }

    @Transactional(rollbackFor={Exception.class})
    public Route create(Route route) {
        return (Route)this.routeDao.save((Object)route);
    }

    @Transactional(rollbackFor={Exception.class})
    public Route update(Long id, Route route) {
        Route existRoute = (Route)this.routeDao.findById((Object)id).orElseThrow(() -> new ProcessedException("\u672a\u627e\u5230\u8be5\u8def\u7531", HttpStatus.NOT_FOUND.value()));
        BeanUtils.copyProperties((Object)route, (Object)existRoute);
        return (Route)this.routeDao.save((Object)existRoute);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Long routeId) {
        this.routeDao.deleteById((Object)routeId);
    }

    public List<Route> findAll(RouteModel.Request.Query query, Sort sort) {
        Specification specification = RouteQueryHelper.querySpecification((RouteModel.Request.Query)query);
        return this.routeDao.findAll(specification, sort);
    }

    public Page<Route> findAll(RouteModel.Request.Query query, Pageable pageable) {
        Specification specification = RouteQueryHelper.querySpecification((RouteModel.Request.Query)query);
        return this.routeDao.findAll(specification, pageable);
    }

    public String refresh() {
        logger.info("route refresh message publish");
        String refreshId = UUIDUtils.randomUUID();
        this.messagePublisher.publish(refreshId);
        return refreshId;
    }

    public String getRefreshCount(String refreshId) {
        Object count = this.redisTemplate.opsForValue().get((Object)("refreshId:" + refreshId));
        return count == null ? "null" : String.valueOf(count);
    }

    @Transactional(rollbackFor={Exception.class})
    public Route createByRouteApply(RouteApply routeApply) {
        Route route = new Route();
        BeanUtils.copyProperties((Object)routeApply, (Object)route);
        route.setRouteId(null);
        route.setStatus(Integer.valueOf(1));
        return (Route)this.routeDao.save((Object)route);
    }

    @Transactional(rollbackFor={Exception.class})
    public void scanResource(Long routeId) {
        List<Route> sortedRoutes = this.sortedRoutes(Stream.of(routeId).collect(Collectors.toSet()));
        Optional<Route> routeOptional = sortedRoutes.stream().filter(r -> r.getRouteId().equals(routeId)).findFirst();
        if (!routeOptional.isPresent()) {
            logger.warn("\u4e0d\u5b58\u5728\u7684\u8def\u7531(routeId:{})", (Object)routeId);
            return;
        }
        Route route = routeOptional.get();
        AutoScanBody autoScanBody = new AutoScanBody();
        RestTemplate restTemplate = new RestTemplate();
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)route.getUrl());
        String url = uriComponentsBuilder.replacePath("/request_mappings").build().toString();
        logger.info("url = {}", (Object)url);
        ResponseEntity resp = restTemplate.getForEntity(url, String.class, new Object[0]);
        String json = (String)resp.getBody();
        Map aaMap = (Map)JsonUtils.fromJson((String)json, (TypeReference)new TypeReference<Map<AuthorizationUri, AuthorizationInfo>>(){});
        logger.info("\u83b7\u53d6request_mapping size = {}", (Object)aaMap.size());
        this.resourceAndPathService.initItem(route, autoScanBody.getIsServicePackage(), autoScanBody, sortedRoutes);
    }

    public void scanResourceByRequest(Set<Long> routeIds, AutoScanBody autoScanBody) {
        List<Route> sortedRoutes = this.sortedRoutes(routeIds);
        for (Long routeId : routeIds) {
            Optional<Route> routeOptional = sortedRoutes.stream().filter(r -> r.getRouteId().equals(routeId)).findFirst();
            if (!routeOptional.isPresent()) {
                logger.warn("\u4e0d\u5b58\u5728\u7684\u8def\u7531(routeId:{}), \u8df3\u8fc7", (Object)routeId);
                continue;
            }
            Route route = routeOptional.get();
            this.resourceAndPathService.initItem(route, autoScanBody.getIsServicePackage(), autoScanBody, sortedRoutes);
        }
    }

    private List<Route> sortedRoutes(Set<Long> routeIds) {
        RouteModel.Request.Query query = new RouteModel.Request.Query();
        query.setRouteIds(StringUtils.join(routeIds, (String)","));
        query.setStatus(Integer.valueOf(1));
        query.setIsExactMatch(Boolean.valueOf(false));
        List<Route> routes = this.findAll(query, Sort.unsorted());
        if (routes.isEmpty()) {
            return routes;
        }
        for (Route route : routes) {
            route.setPath(RouteUtils.reRenderPath((String)route.getPath()));
            route.setUrl(RouteUtils.reRenderUrl((String)route.getUrl()));
        }
        routes.sort(Comparator.nullsLast((o1, o2) -> {
            try {
                PathPattern thatPathPattern;
                if (!routeIds.isEmpty()) {
                    if (routeIds.contains(o1.getRouteId()) && !routeIds.contains(o2.getRouteId())) {
                        return -1;
                    }
                    if (!routeIds.contains(o1.getRouteId()) && routeIds.contains(o2.getRouteId())) {
                        return 1;
                    }
                }
                String processedPrePath1 = o1.getIsExactMatch() != false ? StringUtils.removeEnd((String)o1.getPath(), (String)"/") : StringUtils.appendIfMissing((String)o1.getPath(), (CharSequence)"/**", (CharSequence[])new CharSequence[0]);
                processedPrePath1 = StringUtils.prependIfMissing((String)processedPrePath1, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                String processedPrePath2 = o2.getIsExactMatch() != false ? StringUtils.removeEnd((String)o2.getPath(), (String)"/") : StringUtils.appendIfMissing((String)o2.getPath(), (CharSequence)"/**", (CharSequence[])new CharSequence[0]);
                processedPrePath2 = StringUtils.prependIfMissing((String)processedPrePath2, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                PathPattern thisPathPattern = PathPatternParser.defaultInstance.parse(processedPrePath1);
                int compare = PathPattern.SPECIFICITY_COMPARATOR.compare(thisPathPattern, thatPathPattern = PathPatternParser.defaultInstance.parse(processedPrePath2));
                if (compare == 0) {
                    if (o1.getIsExactMatch().booleanValue() && !o2.getIsExactMatch().booleanValue()) {
                        return -1;
                    }
                    if (!o1.getIsExactMatch().booleanValue() && o2.getIsExactMatch().booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                return compare;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return 0;
            }
        }));
        return routes;
    }

    @Transactional(rollbackFor={Exception.class})
    public void refreshHash() {
        RouteModel.Request.Query query = new RouteModel.Request.Query();
        Specification specification = RouteQueryHelper.querySpecification((RouteModel.Request.Query)query);
        List routes = this.routeDao.findAll(specification);
        for (Route route : routes) {
            String hash = RouteUtils.hash((String)route.getPath());
            route.setHash(hash);
            this.routeDao.save((Object)route);
        }
    }

    public long countByHash(String hash) {
        return this.routeDao.countByHash(hash);
    }
}

