/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.service;

import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.RouteDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.entity.ServiceApi;
import com.xforceplus.query.ServiceApiQueryHelper;
import com.xforceplus.route.api.common.model.ServiceApiModel;
import com.xforceplus.utils.ApiUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceApiService {
    private static final Logger logger = LoggerFactory.getLogger(ServiceApiService.class);
    private final RouteDao routeDao;
    private final ServiceApiDao serviceApiDao;
    private final ResourceApiRelDao resourceApiRelDao;
    private final ResourceDao resourceDao;

    public ServiceApiService(RouteDao routeDao, ServiceApiDao serviceApiDao, ResourceApiRelDao resourceApiRelDao, ResourceDao resourceDao) {
        this.routeDao = routeDao;
        this.serviceApiDao = serviceApiDao;
        this.resourceApiRelDao = resourceApiRelDao;
        this.resourceDao = resourceDao;
    }

    public Page<ServiceApi> page(ServiceApiModel.Request.Query query, Pageable pageable) {
        Specification specification = ServiceApiQueryHelper.querySpecification((ServiceApiModel.Request.Query)query);
        return this.serviceApiDao.findAll(specification, pageable, EntityGraphs.named((String)"ServiceApi.graph"));
    }

    public Page<ServiceApi> page(Specification<ServiceApi> specification, Pageable pageable) {
        return this.serviceApiDao.findAll(specification, pageable, EntityGraphs.named((String)"ServiceApi.graph"));
    }

    public List<ServiceApi> list(ServiceApiModel.Request.Query query, Sort sort) {
        Specification specification = ServiceApiQueryHelper.querySpecification((ServiceApiModel.Request.Query)query);
        List list = this.serviceApiDao.findAll(specification, sort, EntityGraphs.named((String)"ServiceApi.graph"));
        return list;
    }

    public List<ServiceApi> list(Specification<ServiceApi> specification, Sort sort) {
        return this.serviceApiDao.findAll(specification, sort, EntityGraphs.named((String)"ServiceApi.graph"));
    }

    @Transactional(rollbackFor={Exception.class})
    public ServiceApi save(ServiceApiModel.Request.Save model) {
        ServiceApi entity = new ServiceApi();
        BeanUtils.copyProperties((Object)model, (Object)entity, (String[])((String[])Stream.of("app", "resourceApiRels").toArray(String[]::new)));
        entity.setManual(Boolean.valueOf(true));
        entity = (ServiceApi)this.serviceApiDao.saveAndFlush((Object)entity);
        this.bindResources(entity, model.getBindResources());
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public ServiceApi update(long id, ServiceApiModel.Request.Update model) {
        ServiceApi existEntity = this.findById(id);
        if (StringUtils.isBlank((CharSequence)model.getServiceApiName())) {
            model.setServiceApiName(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getServiceApiPath())) {
            model.setServiceApiPath(null);
        }
        if (StringUtils.isBlank((CharSequence)model.getServiceApiUrl())) {
            model.setServiceApiUrl(null);
        }
        BeanUtils.copyProperties((Object)model, (Object)existEntity, (String[])((String[])Stream.of("app", "resourceApiRels").toArray(String[]::new)));
        existEntity = (ServiceApi)this.serviceApiDao.saveAndFlush((Object)existEntity);
        this.bindResources(existEntity, model.getBindResources());
        return existEntity;
    }

    public ServiceApi findById(Long id) {
        return (ServiceApi)this.serviceApiDao.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteById(long id) {
        Optional optionalServiceApi = this.serviceApiDao.findById((Object)id);
        if (!optionalServiceApi.isPresent()) {
            String message = "\u4e0d\u5b58\u5728id:" + id + "\u7684\u670d\u52a1\u63a5\u53e3";
            throw new IllegalArgumentException(message);
        }
        long countRel = this.resourceApiRelDao.countByServiceApiId(id);
        if (countRel > 0L) {
            throw new IllegalArgumentException("\u5df2\u7ecf\u5173\u8054\u5173\u7cfb\u4e0d\u80fd\u5220\u9664");
        }
        this.serviceApiDao.deleteById(Long.valueOf(id));
        this.resourceApiRelDao.deleteByServiceApiId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveResourceApiRel(Long resourceId, Long serviceApiId, String operateUserName) {
        List list = this.resourceApiRelDao.findAll((Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get("serviceApiId"), (Object)serviceApiId));
            predicates.add(builder.equal((Expression)root.get("resourceId"), (Object)resourceId));
            query.where(predicates.toArray(new Predicate[0]));
            return query.getRestriction();
        });
        if (list.isEmpty()) {
            ResourceApiRel resourceApiRel = new ResourceApiRel();
            resourceApiRel.setResourceId(resourceId);
            resourceApiRel.setServiceApiId(serviceApiId);
            resourceApiRel.setCreateUserName(operateUserName);
            this.resourceApiRelDao.saveAndFlush((Object)resourceApiRel);
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(long id, ServiceApiModel.Request.BindResources bindResources) {
        ServiceApi serviceApi = this.findById(id);
        this.bindResources(serviceApi, bindResources);
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(ServiceApi serviceApi, ServiceApiModel.Request.BindResources bindResources) {
        if (bindResources == null) {
            return;
        }
        List resourceIds = bindResources.getResourceIds();
        if (resourceIds == null) {
            return;
        }
        logger.info("resourceIds = " + resourceIds.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
        List existRels = this.resourceApiRelDao.findByServiceApiId(serviceApi.getServiceApiId());
        logger.info("exist api-resource-rels.size = " + existRels.size());
        Set<ResourceApiRel> insertingRels = resourceIds.stream().filter(resourceId -> existRels.stream().map(ResourceApiRel::getResourceId).noneMatch(existId -> existId.equals(resourceId))).map(resourceId -> {
            Optional resourceOptional = this.resourceDao.findById(resourceId);
            if (resourceOptional.isPresent()) {
                ResourceApiRel rel = new ResourceApiRel();
                rel.setResourceId(resourceId);
                rel.setServiceApiId(serviceApi.getServiceApiId());
                return rel;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.bindResources(insertingRels);
        if (bindResources.isOverwrite()) {
            existRels.stream().filter(rel -> resourceIds.stream().noneMatch(resourceId -> resourceId.equals(rel.getResourceId()))).forEach(rel -> {
                logger.info("deleting Resource-Api-Rel record, {}", rel);
                this.resourceApiRelDao.deleteById(rel.getId());
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindResources(Collection<ResourceApiRel> rels) {
        if (!rels.isEmpty()) {
            rels.forEach(arg_0 -> ((ResourceApiRelDao)this.resourceApiRelDao).saveAndFlush(arg_0));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void unbindServiceApiResourceRel(long serviceApiId, long resourceId) {
        this.resourceApiRelDao.deleteByServiceApiIdAndResourceId(serviceApiId, resourceId);
    }

    public long countByHash(String hash) {
        return this.serviceApiDao.countByHash(hash);
    }

    public void refreshHash() {
        this.refreshHashByRouteId(null);
    }

    public void refreshHashByRouteId(Long routeId) {
        Page page;
        ServiceApiModel.Request.Query query = new ServiceApiModel.Request.Query();
        if (routeId != null && routeId > 0L) {
            query.setRouteId(routeId);
        }
        Specification specification = ServiceApiQueryHelper.querySpecification((ServiceApiModel.Request.Query)query);
        Pageable pageable = Pageable.ofSize((int)1000);
        do {
            page = this.serviceApiDao.findAll(specification, pageable);
            for (ServiceApi serviceApi : page) {
                String hash = ApiUtils.hash((String)serviceApi.getServiceApiUrl(), (String)serviceApi.getRequestMethod().name(), (Long)serviceApi.getRouteId());
                serviceApi.setHash(hash);
                serviceApi.setApp(null);
                serviceApi.setResourceApiRels(null);
                this.serviceApiDao.save((Object)serviceApi);
            }
            pageable = page.nextPageable();
        } while (page.hasNext());
    }

    public Map<Long, Set<ServiceApiModel.Response.ServiceApiWithResource>> all() {
        try {
            return this.routeDao.all();
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return Collections.emptyMap();
        }
    }
}

