package com.xforceplus.config;

import com.xforceplus.route.listener.MessagePublisher;
import com.xforceplus.route.listener.RedisMessagePublisher;
import com.xforceplus.route.listener.Topic;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;


@Configuration
public class RedisConfig {
    @Bean("refreshingRouteTopic")
    public ChannelTopic topic() {
        return new ChannelTopic(Topic.name);
    }

    @Bean("refreshingRouteRedisPublisher")
    public MessagePublisher redisPublisher(StringRedisTemplate redisTemplate,
                                           @Qualifier("refreshingRouteTopic") ChannelTopic topic) {
        return new RedisMessagePublisher(redisTemplate, topic);
    }

}
