package com.xforceplus.route;

import io.geewit.core.exception.ProcessedException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpCheckUtils {
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(?i)(http|https):(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)(:(\\d*(?:\\{[^/]+?\\})?))?)?([^?#]*)(\\?(.*))?");


    public static void checkHttpUrl(String httpUrl) {
        Assert.notNull(httpUrl, "Url不能为空。");
        Matcher matcher = HTTP_URL_PATTERN.matcher(httpUrl);
        if (matcher.matches()) {
            String scheme = matcher.group(1);
            String host = matcher.group(5);
            if (StringUtils.hasLength(scheme) && !StringUtils.hasLength(host)) {
                throw new ProcessedException("[" + httpUrl + "] 不是一个有效的url");
            }
        } else {
            throw new ProcessedException("[" + httpUrl + "] 不是一个有效的url");
        }
    }
}
