package com.xforceplus.route.listener;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;

/**
 * @author geewit
 */
@Slf4j
public class RedisMessagePublisher implements MessagePublisher {
    private final StringRedisTemplate redisTemplate;

    private final ChannelTopic topic;

    public RedisMessagePublisher(StringRedisTemplate redisTemplate, ChannelTopic topic) {
        this.redisTemplate = redisTemplate;
        this.topic = topic;
    }

    @Override
    public void publish(String message) {
        log.debug("refresh route message = {} publish", message);
        redisTemplate.convertAndSend(topic.getTopic(), message);
    }
}
