/*
 * Copyright (c)  2015~2025, Xforceplus
 * All rights reserved.
 * Project: route-mgmt
 * ClassName: RouteRefreshTask   
 * Date: 2021-07-21 11:38:54
 * Author: zhouxin
 */
package com.xforceplus.route.schedule;

import com.xforceplus.route.listener.MessagePublisher;
import io.geewit.utils.uuid.UUIDUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @Description: 每天中午12点和晚上10点刷一次路由
 * @CopyRight: 上海云砺信息科技有限公司
 * @Author: zhouxin
 * @Email: yf_zhouxin@xforceplus.com
 * @Date: 2021/7/21 11:38:54
 */

@Slf4j
@Component
public class RouteRefreshTask {

    private final MessagePublisher messagePublisher;

    public RouteRefreshTask(MessagePublisher messagePublisher) {
        this.messagePublisher = messagePublisher;
    }

    /**
     * 每天中午12点和晚上10点刷一次路由
     */
    @Scheduled(cron = "0 0 12,22 * * ? ")
    public void refreshRoute() {
        String refreshId = UUIDUtils.randomUUID();
        messagePublisher.publish(refreshId);
        log.info("==========route refreshing==========");
    }

}
