package com.xforceplus.route.service;

import com.xforceplus.dao.ResourceApiRelDao;
import com.xforceplus.dao.ResourceDao;
import com.xforceplus.dao.ServiceApiDao;
import com.xforceplus.entity.Resource;
import com.xforceplus.query.ResourceQueryHelper;
import com.xforceplus.route.api.common.model.ResourceModel.*;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

@SuppressWarnings("all")
@Service
public class ResourceService {
    private final static Logger logger = LoggerFactory.getLogger(ResourceService.class);

    private final ResourceDao resourceDao;

    private final ResourceApiRelDao resourceApiRelDao;

    private final ServiceApiDao serviceApiDao;

    private final RedisTemplate redisTemplate;


    public ResourceService(ResourceDao resourceDao, ResourceApiRelDao resourceApiRelDao, ServiceApiDao serviceApiDao, RedisTemplate redisTemplate) {
        this.resourceDao = resourceDao;
        this.resourceApiRelDao = resourceApiRelDao;
        this.serviceApiDao = serviceApiDao;
        this.redisTemplate = redisTemplate;
    }

    public Page<Resource> page(Request.Query query, Pageable pageable) {
        Specification<Resource> specification = ResourceQueryHelper.querySpecification(query);
        Page<Resource> page = resourceDao.findAll(specification, pageable, EntityGraphs.named(Resource.NAMED_ENTITY_GRAPH_DEFAULT));
        if (!query.isFlat() && !page.isEmpty()) {
            for (Resource resource : page) {
                List<Resource> children = resourceDao.findByParentId(resource.getResourceId());
                if (CollectionUtils.isEmpty(children)) {
                    resource.setChildren(null);
                } else {
                    resource.setChildren(children);
                }
            }
        }
        return page;
    }

    public Page<Resource> page(Specification<Resource> specification, Pageable pageable) {
        Page<Resource> page = resourceDao.findAll(specification, pageable, EntityGraphs.named(Resource.NAMED_ENTITY_GRAPH_DEFAULT));
        return page;
    }

    public List<Resource> list(Request.Query query, Sort sort) {
        Specification<Resource> specification = ResourceQueryHelper.querySpecification(query);
        List<Resource> list = resourceDao.findAll(specification, sort, EntityGraphs.named(Resource.NAMED_ENTITY_GRAPH_DEFAULT));
        return list;
    }

    public List<Resource> list(Specification<Resource> specification, Sort sort) {
        return resourceDao.findAll(specification, sort, EntityGraphs.named(Resource.NAMED_ENTITY_GRAPH_DEFAULT));
    }

    public Optional<Resource> findOne(Request.Query query) {
        Specification<Resource> specification = ResourceQueryHelper.querySpecification(query);
        return resourceDao.findOne(specification);
    }

    public long count(Request.Query query) {
        Specification<Resource> specification = ResourceQueryHelper.querySpecification(query);
        return resourceDao.count(specification);
    }
}
