/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.autoscan.config;

import com.xforceplus.api.global.route.RouteApi;
import com.xforceplus.tenant.security.autoscan.config.AutoScanProperties;
import com.xforceplus.tenant.security.autoscan.listener.AutoScanApplicationContextListener;
import com.xforceplus.tenant.security.autoscan.servlet.AutoScanRequestMappingsServlet;
import com.xforceplus.tenant.security.client.feign.utils.FeignUtils;
import feign.Client;
import javax.servlet.Servlet;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
@EnableConfigurationProperties(value={SpringDataWebProperties.class, AutoScanProperties.class})
public class TenantAutoScanConfiguration
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantAutoScanConfiguration.class);
    private final SpringDataWebProperties springDataWebProperties;
    private final AutoScanProperties autoScanProperties;
    @Value(value="${xforce.tenant.service.tenant_service_global:http://tenant-service:8080}")
    private String tenantServiceUrl;
    private ResourceLoader resourceLoader;

    public TenantAutoScanConfiguration(SpringDataWebProperties springDataWebProperties, AutoScanProperties autoScanProperties) {
        this.springDataWebProperties = springDataWebProperties;
        this.autoScanProperties = autoScanProperties;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Bean
    public ApplicationListener autoScanApplicationContextListener() {
        if (this.autoScanProperties != null && this.autoScanProperties.getEnabled() != null && this.autoScanProperties.getEnabled().booleanValue()) {
            logger.info("\u5f00\u5173\u5df2\u7ecf\u6253\u5f00\u3002");
            return new AutoScanApplicationContextListener(this.autoScanProperties);
        }
        logger.info("\u5f00\u5173\u672a\u6253\u5f00\u3002");
        return event -> {};
    }

    @Bean
    public AutoScanRequestMappingsServlet autoScanRequestMappingsServlet() {
        return new AutoScanRequestMappingsServlet();
    }

    @Bean
    public ServletRegistrationBean getServletRegistrationBean(AutoScanRequestMappingsServlet autoScanRequestMappingsServlet) {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)autoScanRequestMappingsServlet, new String[0]);
        bean.addUrlMappings(new String[]{"/request_mappings"});
        return bean;
    }

    private feign.okhttp.OkHttpClient client(OkHttpClient okHttpClient) {
        feign.okhttp.OkHttpClient client = new feign.okhttp.OkHttpClient(okHttpClient);
        return client;
    }

    @Bean
    public RouteApi routeApi(@Autowired @Qualifier(value="tenantOkHttpClient") OkHttpClient tenantOkHttpClient) {
        RouteApi routeApi = (RouteApi)FeignUtils.of((Client)this.client(tenantOkHttpClient), (ResourceLoader)this.resourceLoader, (SpringDataWebProperties)this.springDataWebProperties).target(RouteApi.class, this.tenantServiceUrl);
        return routeApi;
    }
}

