/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.autoscan.listener;

import com.xforceplus.api.global.route.RouteApi;
import com.xforceplus.tenant.security.autoscan.config.AutoScanProperties;
import com.xforceplus.tenant.security.autoscan.model.AutoScanBody;
import com.xforceplus.tenant.security.autoscan.model.ResourceItem;
import com.xforceplus.tenant.security.autoscan.utils.AuthorizationInfoUtils;
import com.xforceplus.tenant.security.autoscan.utils.ResourceCodeUtils;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class AutoScanApplicationContextListener
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AutoScanApplicationContextListener.class);
    private ApplicationContext applicationContext;
    private final AtomicBoolean locker = new AtomicBoolean(false);
    @Autowired
    private final AutoScanProperties autoScanProperties;
    @Value(value="${server.port:8080}")
    private String localPort;
    @Autowired
    private RouteApi routeApi;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public AutoScanApplicationContextListener(AutoScanProperties autoScanProperties) {
        this.autoScanProperties = autoScanProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        boolean result = this.locker.compareAndSet(false, true);
        if (!result) {
            logger.info("\u8be5\u4e8b\u4ef6\u88ab\u9501\u5b9a, \u7b49\u5f85\u5c31\u7eea......");
            return;
        }
        logger.info("\u8fdb\u5165\u5e94\u7528\u76d1\u542c\u65b9\u6cd5");
        this.executorService.execute(() -> {
            try {
                logger.info("\u8fdb\u5165\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u529f\u80fd\u65b9\u6cd5");
                this.doAutoScan();
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u529f\u80fd\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private void doAutoScan() throws Exception {
        String body;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().stream().filter(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter).forEach(httpMessageConverter -> ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(StandardCharsets.UTF_8));
        if (StringUtils.isBlank((CharSequence)this.autoScanProperties.getRouteIds())) {
            throw new RuntimeException("\u542f\u52a8\u81ea\u52a8\u626b\u63cf\uff0c\u5374\u6ca1\u914d\u7f6e\u8def\u7531routeIds.");
        }
        String routeIds = this.autoScanProperties.getRouteIds().replace(",", ".");
        String host = InetAddress.getLocalHost().getHostAddress();
        List resourceItems = ResourceCodeUtils.readYmlResource((String)this.autoScanProperties.getYamlPath());
        HashSet resourceCodeSet = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)resourceItems)) {
            resourceItems.stream().filter(Objects::nonNull).forEach(item -> this.addResourceCode(resourceCodeSet, (ResourceItem)item));
        }
        if (StringUtils.isBlank((CharSequence)(body = this.getBody(restTemplate, host)))) {
            logger.info("\u5c1d\u8bd5\u8c03\u7528\u63a5\u53e3\u672a\u6210\u529f");
            return;
        }
        logger.info("\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u63a5\u53e3");
        Map aaMap = AuthorizationInfoUtils.getAuthorizationUriAuthorizationInfoMap((ApplicationContext)this.applicationContext, resourceCodeSet);
        AutoScanBody autoScanBody = new AutoScanBody();
        autoScanBody.setAaMap(aaMap);
        autoScanBody.setResourceItemList(resourceItems);
        autoScanBody.setRouteIds(routeIds);
        autoScanBody.setHost(host);
        autoScanBody.setIsServicePackage(this.autoScanProperties.getIsServicePackage());
        ResponseEntity result = this.routeApi.batchScan(autoScanBody);
        logger.info("\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u7ed3\u679c, result=={}", result.getResult());
    }

    private void addResourceCode(Set<String> resourceCodeSet, ResourceItem resourceItem) {
        resourceCodeSet.add(resourceItem.getResourceCode());
        if (!CollectionUtils.isEmpty((Collection)resourceItem.getChildren())) {
            resourceItem.getChildren().forEach(item -> this.addResourceCode(resourceCodeSet, (ResourceItem)item));
        }
    }

    private String getBody(RestTemplate restTemplate, String host) {
        String url = "http://" + host + ":" + this.localPort + "/request_mappings";
        for (int i = 0; i < 20; ++i) {
            try {
                TimeUnit.SECONDS.sleep(30L);
                logger.info("\u8fdb\u884c\u6d4b\u8bd5\u5faa\u73af,i=={}", (Object)i);
                org.springframework.http.ResponseEntity resp = restTemplate.getForEntity(url, String.class, new Object[0]);
                if (resp.getStatusCode().value() != HttpStatus.OK.value()) continue;
                return (String)resp.getBody();
            }
            catch (Exception e) {
                logger.error("\u6267\u884c\u6d4b\u8bd5\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }
}

