/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.autoscan.listener;

import com.xforceplus.api.global.autoscan.AutoscanApi;
import com.xforceplus.tenant.security.autoscan.config.AutoScanProperties;
import com.xforceplus.tenant.security.autoscan.model.AutoScanBody;
import com.xforceplus.tenant.security.autoscan.model.RequestMappingsHolder;
import com.xforceplus.tenant.security.autoscan.model.ResourceItem;
import com.xforceplus.tenant.security.autoscan.utils.AuthorizationInfoUtils;
import com.xforceplus.tenant.security.autoscan.utils.ResourceCodeUtils;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class AutoScanApplicationContextListener
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(AutoScanApplicationContextListener.class);
    private final AutoScanProperties autoScanProperties;
    private ApplicationContext applicationContext;
    private final AtomicBoolean locker = new AtomicBoolean(false);
    @Autowired
    private AutoscanApi routeApi;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public AutoScanApplicationContextListener(AutoScanProperties autoScanProperties) {
        this.autoScanProperties = autoScanProperties;
        log.info("tenant-security.AutoScanApplicationContextListener initialized");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        this.buildAutoScanBody();
        AtomicInteger count = new AtomicInteger(0);
        while (!this.locker.get() && count.get() < 10) {
            if (count.get() > 0) {
                log.info("Autoscan,\u91cd\u8bd5\u7b2c{}\u6b21", (Object)count.get());
            }
            this.locker.compareAndSet(false, true);
            log.info("Autoscan,\u8fdb\u5165\u5e94\u7528\u76d1\u542c\u65b9\u6cd5");
            this.executorService.execute(() -> {
                try {
                    log.info("Autoscan,\u8fdb\u5165\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u529f\u80fd\u65b9\u6cd5");
                    this.doAutoScan();
                    return;
                }
                catch (Exception e) {
                    log.error("Autoscan,\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u529f\u80fd\u5931\u8d25", (Throwable)e);
                    this.locker.set(false);
                    try {
                        int wait = 30;
                        Thread.sleep(wait * 1000);
                        log.info("Autoscan,\u7b49\u5f85{}\u79d2\u91cd\u8bd5", (Object)wait);
                    }
                    catch (InterruptedException interruptedException) {
                        log.warn(interruptedException.getMessage());
                        return;
                    }
                }
                finally {
                    count.getAndIncrement();
                }
            });
        }
    }

    private void buildAutoScanBody() {
        ArrayList<ResourceItem> resources;
        Properties properties;
        if (StringUtils.isBlank((CharSequence)this.autoScanProperties.getRouteIds())) {
            throw new RuntimeException("Autoscan,\u542f\u52a8\u81ea\u52a8\u626b\u63cf, \u5374\u6ca1\u914d\u7f6e\u8def\u7531 routeIds.");
        }
        if (StringUtils.isBlank((CharSequence)this.autoScanProperties.getRoutePaths())) {
            throw new RuntimeException("Autoscan,\u542f\u52a8\u81ea\u52a8\u626b\u63cf, \u5374\u6ca1\u914d\u7f6e\u8def\u7531 routePaths.");
        }
        Properties mergedProperties = null;
        Properties yaml = ResourceCodeUtils.readYmlResource((String)this.autoScanProperties.getYamlPath());
        if (yaml != null) {
            mergedProperties = yaml;
        }
        if ((properties = ResourceCodeUtils.readPropertiesResource((String)this.autoScanProperties.getPropertiesPath())) != null) {
            if (mergedProperties == null) {
                mergedProperties = properties;
            } else {
                mergedProperties.putAll((Map<?, ?>)properties);
            }
        }
        if (mergedProperties != null) {
            resources = new ArrayList<ResourceItem>(mergedProperties.size());
            for (Map.Entry<Object, Object> entry : mergedProperties.entrySet()) {
                ResourceItem resourceItem = new ResourceItem();
                resourceItem.setResourceCode(StringUtils.replace((String)entry.getKey().toString(), (String)".", (String)":"));
                resourceItem.setResourceName(entry.getValue().toString());
                resources.add(resourceItem);
            }
        } else {
            String message = "\u6c92\u6709\u83b7\u53d6\u5230" + this.autoScanProperties.getYamlPath() + "\u548c" + this.autoScanProperties.getPropertiesPath() + "\u4efb\u4f55\u4e00\u4e2a\u6587\u4ef6";
            log.warn(message);
            resources = new ArrayList();
        }
        String routeIds = StringUtils.trimToNull((String)this.autoScanProperties.getRouteIds());
        String routePaths = StringUtils.trimToNull((String)this.autoScanProperties.getRoutePaths());
        if (RequestMappingsHolder.REQUEST_MAPPINGS == null) {
            RequestMappingsHolder.REQUEST_MAPPINGS = AuthorizationInfoUtils.getAuthorizationUriAuthorizationInfoMap((ApplicationContext)this.applicationContext, null);
        }
        if (RequestMappingsHolder.AUTO_SCAN_BODY == null) {
            RequestMappingsHolder.AUTO_SCAN_BODY = AutoScanBody.builder().aaMap(RequestMappingsHolder.REQUEST_MAPPINGS).resources(resources).routeIds(routeIds).routePaths(routePaths).build();
        }
    }

    private void doAutoScan() throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().stream().filter(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter).forEach(httpMessageConverter -> ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(StandardCharsets.UTF_8));
        if (RequestMappingsHolder.AUTO_SCAN_BODY != null && RequestMappingsHolder.AUTO_SCAN_BODY.valid()) {
            log.info("Autoscan,\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u63a5\u53e3");
            ResponseEntity result = this.routeApi.batchScan(RequestMappingsHolder.AUTO_SCAN_BODY);
            log.info("Autoscan,\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u7ed3\u679c, result=={}", result.getResult());
        } else {
            log.info("AutoscanBody\u65e0\u6548");
        }
    }

    private void addResourceCode(Set<String> resourceCodeSet, ResourceItem resourceItem) {
        resourceCodeSet.add(resourceItem.getResourceCode());
    }
}

