
package com.xforceplus.tenant.security.autoscan.servlet;


import com.xforceplus.tenant.security.autoscan.model.AuthorizationInfo;
import com.xforceplus.tenant.security.autoscan.model.AuthorizationUri;
import com.xforceplus.tenant.security.autoscan.utils.AuthorizationInfoUtils;
import io.geewit.web.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.MediaType;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

@SuppressWarnings("all")
@WebServlet(
        name = "RequestMappingsServlet",
        urlPatterns = {"/request_mappings"}
)
public class AutoScanRequestMappingsServlet extends HttpServlet implements ApplicationContextAware {
    private final static Logger logger = LoggerFactory.getLogger(AutoScanRequestMappingsServlet.class);

    private ApplicationContext applicationContext;

    public AutoScanRequestMappingsServlet() {
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map<AuthorizationUri, AuthorizationInfo> mappings = AuthorizationInfoUtils.getAuthorizationUriAuthorizationInfoMap(this.applicationContext, null);
        this.writeJson(mappings, response);
    }



    private void writeJson(Map<AuthorizationUri, AuthorizationInfo> mappings, HttpServletResponse response) throws IOException {
        String json = JsonUtils.toJson(mappings);
        response.setContentType(MediaType.APPLICATION_JSON_UTF8_VALUE);
        PrintWriter out = response.getWriter();
        out.write(json);
        out.flush();
    }
}
