package com.xforceplus.tenant.security.autoscan.config;

import com.xforceplus.api.global.route.RouteApi;
import com.xforceplus.tenant.security.autoscan.listener.AutoScanApplicationContextListener;
import com.xforceplus.tenant.security.autoscan.servlet.AutoScanRequestMappingsServlet;
import com.xforceplus.tenant.security.client.feign.utils.FeignUtils;
import feign.okhttp.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ResourceLoader;

/**
 * @author geewit
 */
@Configuration
@EnableConfigurationProperties({SpringDataWebProperties.class, AutoScanProperties.class})
public class TenantAutoScanConfiguration implements ResourceLoaderAware {
    private final static Logger logger = LoggerFactory.getLogger(TenantAutoScanConfiguration.class);

    private final SpringDataWebProperties springDataWebProperties;

    private final AutoScanProperties autoScanProperties;

    @Value("${xforce.tenant.service.tenant_service_global:http://tenant-service:8080}")
    private String tenantServiceUrl;

    public TenantAutoScanConfiguration(SpringDataWebProperties springDataWebProperties, AutoScanProperties autoScanProperties) {
        this.springDataWebProperties = springDataWebProperties;
        this.autoScanProperties = autoScanProperties;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private ResourceLoader resourceLoader;


    @Bean
    public ApplicationListener autoScanApplicationContextListener() {
        if (autoScanProperties != null && this.autoScanProperties.getEnabled() != null && this.autoScanProperties.getEnabled()) {
            logger.info("开关已经打开。");
            return new AutoScanApplicationContextListener(this.autoScanProperties);
        } else {
            logger.info("开关未打开。");
            return (ApplicationListener<ContextRefreshedEvent>) event -> {
            };
        }
    }

    @Bean
    public AutoScanRequestMappingsServlet autoScanRequestMappingsServlet() {
        return new AutoScanRequestMappingsServlet();
    }

    @Bean
    public ServletRegistrationBean getServletRegistrationBean(AutoScanRequestMappingsServlet autoScanRequestMappingsServlet) {
        ServletRegistrationBean bean = new ServletRegistrationBean(autoScanRequestMappingsServlet);
        //访问路径值
        bean.addUrlMappings("/request_mappings");
        return bean;
    }

    private OkHttpClient client(okhttp3.OkHttpClient okHttpClient) {
        OkHttpClient client = new OkHttpClient(okHttpClient);
        return client;
    }

    @Bean
    public RouteApi routeApi(@Autowired @Qualifier("tenantOkHttpClient")okhttp3.OkHttpClient tenantOkHttpClient) {
        RouteApi routeApi = FeignUtils.of(this.client(tenantOkHttpClient), this.resourceLoader, this.springDataWebProperties)
                .target(RouteApi.class, this.tenantServiceUrl);
        return routeApi;
    }
}
