/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.autoscan.config;

import com.xforceplus.api.global.autoscan.AutoscanApi;
import com.xforceplus.tenant.security.autoscan.config.AutoScanProperties;
import com.xforceplus.tenant.security.autoscan.listener.AutoScanApplicationContextListener;
import com.xforceplus.tenant.security.autoscan.servlet.AutoScanRequestMappingsServlet;
import com.xforceplus.tenant.security.client.feign.config.XforceDataWebProperties;
import com.xforceplus.tenant.security.client.feign.utils.FeignUtils;
import feign.Client;
import feign.Feign;
import feign.RequestInterceptor;
import javax.servlet.Servlet;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.web.SpringDataWebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@ConditionalOnMissingBean(value={TenantAutoScanConfiguration.class})
@Configuration(value="tenantAutoScanConfiguration")
@AutoConfigureAfter(name={"tenantFeignConfiguration"})
@EnableConfigurationProperties(value={AutoScanProperties.class, XforceDataWebProperties.class})
public class TenantAutoScanConfiguration
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantAutoScanConfiguration.class);
    private final SpringDataWebProperties springDataWebProperties;
    private final XforceDataWebProperties xforceDataWebProperties;
    private final AutoScanProperties autoScanProperties;
    @Value(value="${xforce.tenant.service.route_service:http://route-mgmt:8080}")
    private String routeServiceUrl;
    private ResourceLoader resourceLoader;

    public TenantAutoScanConfiguration(@Autowired(required=false) XforceDataWebProperties xforceDataWebProperties, @Autowired(required=false) SpringDataWebProperties springDataWebProperties, AutoScanProperties autoScanProperties) {
        this.xforceDataWebProperties = xforceDataWebProperties;
        this.springDataWebProperties = springDataWebProperties;
        this.autoScanProperties = autoScanProperties;
        logger.info("TenantAutoScanConfiguration initialized");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Bean(name={"autoScanApplicationContextListener"})
    public ApplicationListener autoScanApplicationContextListener() {
        if (this.autoScanProperties != null && this.autoScanProperties.getEnabled() != null && this.autoScanProperties.getEnabled().booleanValue()) {
            logger.info("Autoscan,\u5f00\u5173\u5df2\u7ecf\u6253\u5f00\u3002");
            return new AutoScanApplicationContextListener(this.autoScanProperties);
        }
        logger.info("Autoscan,\u5f00\u5173\u672a\u6253\u5f00\u3002");
        return event -> {};
    }

    @Bean(name={"autoScanRequestMappingsServlet"})
    public AutoScanRequestMappingsServlet autoScanRequestMappingsServlet() {
        return new AutoScanRequestMappingsServlet();
    }

    @Bean
    public ServletRegistrationBean getServletRegistrationBean(AutoScanRequestMappingsServlet autoScanRequestMappingsServlet) {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)autoScanRequestMappingsServlet, new String[0]);
        bean.addUrlMappings(new String[]{"/request_mappings"});
        return bean;
    }

    private feign.okhttp.OkHttpClient client(OkHttpClient okHttpClient) {
        feign.okhttp.OkHttpClient client = new feign.okhttp.OkHttpClient(okHttpClient);
        return client;
    }

    @Bean
    public AutoscanApi routeApi(@Autowired @Qualifier(value="tenantOkHttpClient") OkHttpClient tenantOkHttpClient, @Autowired(required=false) @Qualifier(value="tenantTokenRequestInterceptor") RequestInterceptor requestInterceptor) {
        String pageParameter = StringUtils.defaultString((String)this.xforceDataWebProperties.getPageable().getPageParameter(), (String)this.springDataWebProperties.getPageable().getPageParameter());
        String sizeParameter = StringUtils.defaultString((String)this.xforceDataWebProperties.getPageable().getSizeParameter(), (String)this.springDataWebProperties.getPageable().getSizeParameter());
        String sortParameter = StringUtils.defaultString((String)this.xforceDataWebProperties.getSort().getSortParameter(), (String)this.springDataWebProperties.getSort().getSortParameter());
        Boolean oneIndexedParameters = this.xforceDataWebProperties.getPageable().isOneIndexedParameters();
        Feign.Builder builder = FeignUtils.of((Client)this.client(tenantOkHttpClient), (ResourceLoader)this.resourceLoader, (String)pageParameter, (String)sizeParameter, (String)sortParameter, (Boolean)oneIndexedParameters);
        if (requestInterceptor != null) {
            builder.requestInterceptor(requestInterceptor);
        }
        AutoscanApi routeApi = (AutoscanApi)builder.target(AutoscanApi.class, this.routeServiceUrl);
        return routeApi;
    }
}

