/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.autoscan.listener;

import com.xforceplus.api.global.autoscan.AutoscanApi;
import com.xforceplus.tenant.security.autoscan.config.AutoScanProperties;
import com.xforceplus.tenant.security.autoscan.model.AutoScanBody;
import com.xforceplus.tenant.security.autoscan.model.RequestMappingsHolder;
import com.xforceplus.tenant.security.autoscan.model.ResourceItem;
import com.xforceplus.tenant.security.autoscan.utils.AuthorizationInfoUtils;
import com.xforceplus.tenant.security.autoscan.utils.ResourceCodeUtils;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class AutoScanApplicationContextListener
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AutoScanApplicationContextListener.class);
    private ApplicationContext applicationContext;
    private final AtomicBoolean locker = new AtomicBoolean(false);
    @Autowired
    private final AutoScanProperties autoScanProperties;
    @Autowired
    private AutoscanApi routeApi;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public AutoScanApplicationContextListener(AutoScanProperties autoScanProperties) {
        this.autoScanProperties = autoScanProperties;
        logger.info("tenant-security.AutoScanApplicationContextListener initialized");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        AtomicInteger count = new AtomicInteger(0);
        while (!this.locker.get() && count.get() < 10) {
            if (count.get() > 0) {
                logger.info("Autoscan,\u91cd\u8bd5\u7b2c{}\u6b21", (Object)count.get());
            }
            this.locker.compareAndSet(false, true);
            logger.info("Autoscan,\u8fdb\u5165\u5e94\u7528\u76d1\u542c\u65b9\u6cd5");
            this.executorService.execute(() -> {
                try {
                    logger.info("Autoscan,\u8fdb\u5165\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u529f\u80fd\u65b9\u6cd5");
                    this.doAutoScan();
                    return;
                }
                catch (Exception e) {
                    logger.error("Autoscan,\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u529f\u80fd\u5931\u8d25", (Throwable)e);
                    this.locker.set(false);
                    try {
                        int wait = 30;
                        Thread.sleep(wait * 1000);
                        logger.info("Autoscan,\u7b49\u5f85{}\u79d2\u91cd\u8bd5", (Object)wait);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.warn(interruptedException.getMessage());
                        return;
                    }
                }
                finally {
                    count.getAndIncrement();
                }
            });
        }
    }

    private void doAutoScan() throws Exception {
        ArrayList<ResourceItem> resources;
        Properties properties;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().stream().filter(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter).forEach(httpMessageConverter -> ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(StandardCharsets.UTF_8));
        if (StringUtils.isBlank((CharSequence)this.autoScanProperties.getRouteIds())) {
            throw new RuntimeException("Autoscan,\u542f\u52a8\u81ea\u52a8\u626b\u63cf\uff0c\u5374\u6ca1\u914d\u7f6e\u8def\u7531routeIds.");
        }
        String routeIds = StringUtils.trimToNull((String)this.autoScanProperties.getRouteIds());
        Properties mergedProperties = null;
        Properties yaml = ResourceCodeUtils.readPropertiesResource((String)this.autoScanProperties.getYamlPath());
        if (yaml != null) {
            mergedProperties = yaml;
        }
        if ((properties = ResourceCodeUtils.readPropertiesResource((String)this.autoScanProperties.getPropertiesPath())) != null) {
            if (mergedProperties == null) {
                mergedProperties = properties;
            } else {
                mergedProperties.putAll((Map<?, ?>)properties);
            }
        }
        if (mergedProperties != null) {
            resources = new ArrayList(mergedProperties.size());
            for (Map.Entry<Object, Object> entry : mergedProperties.entrySet()) {
                ResourceItem resourceItem = new ResourceItem();
                resourceItem.setResourceCode(StringUtils.replace((String)entry.getKey().toString(), (String)".", (String)":"));
                resourceItem.setResourceName(entry.getValue().toString());
                resources.add(resourceItem);
            }
        } else {
            resources = new ArrayList<ResourceItem>();
        }
        HashSet resourceCodeSet = new HashSet();
        if (!CollectionUtils.isEmpty(resources)) {
            resources.stream().filter(Objects::nonNull).forEach(item -> resourceCodeSet.add(item.getResourceCode()));
        }
        RequestMappingsHolder.REQUEST_MAPPINGS = AuthorizationInfoUtils.getAuthorizationUriAuthorizationInfoMap((ApplicationContext)this.applicationContext, null);
        logger.info("Autoscan,\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u63a5\u53e3");
        AutoScanBody autoScanBody = new AutoScanBody();
        autoScanBody.setAaMap(RequestMappingsHolder.REQUEST_MAPPINGS);
        autoScanBody.setResources(resources);
        autoScanBody.setRouteIds(routeIds);
        autoScanBody.setIsServicePackage(this.autoScanProperties.getIsServicePackage());
        ResponseEntity result = this.routeApi.batchScan(autoScanBody);
        logger.info("Autoscan,\u8c03\u7528\u81ea\u52a8\u626b\u63cf\u7ed3\u679c, result=={}", result.getResult());
    }

    private void addResourceCode(Set<String> resourceCodeSet, ResourceItem resourceItem) {
        resourceCodeSet.add(resourceItem.getResourceCode());
    }
}

