
package com.xforceplus.tenant.security.autoscan.servlet;


import com.xforceplus.tenant.security.autoscan.model.RequestMappingsHolder;
import io.geewit.web.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.MediaType;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@SuppressWarnings("all")
@WebServlet(
        name = "RequestMappingsServlet",
        urlPatterns = {"/request_mappings"}
)
public class AutoScanRequestMappingsServlet extends HttpServlet implements ApplicationContextAware {
    private final static Logger logger = LoggerFactory.getLogger(AutoScanRequestMappingsServlet.class);

    private ApplicationContext applicationContext;

    public AutoScanRequestMappingsServlet() {
        logger.info("tenant-security.AutoScanRequestMappingsServlet initialized");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String json = JsonUtils.toJson(RequestMappingsHolder.REQUEST_MAPPINGS);
        response.setContentType(MediaType.APPLICATION_JSON_UTF8_VALUE);
        PrintWriter out = response.getWriter();
        out.write(json);
        out.flush();
    }
}
