package com.xforceplus.api.global.autoscan;

import com.xforceplus.tenant.security.autoscan.model.AutoScanBody;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import org.springframework.web.bind.annotation.*;


/**
 * 路由绑定相关接口 (global)
 *
 * @author geewit
 */
public interface AutoscanApi {

    @SuppressWarnings("all")
    interface Path {
        /***
         * Path Prefix API {@value}
         */
        String PATH_PREFIX = "${xforce.route.service.url.prefix:/api}";
        /***
         * API Version {@value}
         */
        String API_VERSION = "${xforce.route.service.version:}";
        /**
         * global {@value}
         */
        String PATH_GLOBAL = "/global";
        /***
         * Path Global Prefix {@value}
         */
        String PATH_GLOBAL_PREFIX = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/routes";

        String SCAN = PATH_GLOBAL_PREFIX + "/{routeId}/scan";

        String BATCH_SCAN = PATH_GLOBAL_PREFIX + "/batchScan";
    }

    /**
     * 根据路由id扫描接口
     * @param routeId
     * @return 处理结果
     */
    @ResponseBody
    @RequestMapping(name = "根据路由id扫描接口", value = Path.SCAN, method = RequestMethod.GET)
    ResponseEntity<String> scan(@PathVariable("routeId") Long routeId);

    /**
     * 批量扫描接口
     * @param autoScanBody
     * @return 处理结果
     */
    @ResponseBody
    @RequestMapping(name = "批量扫描接口", value = Path.BATCH_SCAN, method = RequestMethod.POST)
    ResponseEntity<String> batchScan(@RequestBody AutoScanBody autoScanBody);
}
