package com.xforceplus.tenant.security.client.feign.support;


import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author geewit
 */
@ConfigurationProperties("xforce.tenant.security.auth")
@FieldNameConstants
@Setter
@Getter
public class OauthClientProperties {
    private String requestUrl;

    private long expireHours;

    private Params params;

    private long sleepMillis = 1000L;

    private int maxFailTimes = 10;

    @FieldNameConstants
    @Setter
    @Getter
    public static class Params {
        private String clientId;

        private String secret;
    }
}
