package com.xforceplus.tenant.security.client.feign.interceptor;

import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.token.domain.UserType;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

/**
 * 微服务中拦截调用微服务请求，把x-app-token塞入header
 * @author geewit
 */
@Builder
@Slf4j
public class TenantTokenRequestInterceptor implements RequestInterceptor {

    public TenantTokenRequestInterceptor(ClientService clientService) {
        this.clientService = clientService;
        log.info("TenantTokenRequestInterceptor initialized");
    }

    private final ClientService clientService;

    @Override
    public void apply(RequestTemplate template) {
        String token = clientService.token();
        if(token != null) {
            log.info("token = " + token);
            template.header(UserType.APPID.tokenKey(), token);
        }
    }
}
