package com.xforceplus.tenant.security.client.feign.support;


import lombok.*;
import lombok.experimental.FieldNameConstants;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author geewit
 */
@ConfigurationProperties("xforce.tenant.security.auth")
@FieldNameConstants
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Setter
@Getter
public class OauthClientProperties {
    private String requestUrl;

    private long expireHours;

    private Params params;

    @Builder.Default
    private long sleepMillis = 1000L;

    @Builder.Default
    private int maxFailTimes = 10;

    @FieldNameConstants
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    @Setter
    @Getter
    public static class Params {
        private String clientId;

        private String secret;
    }
}
