/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.interceptor;

import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.token.domain.UserType;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantTokenRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantTokenRequestInterceptor.class);
    private final ClientService clientService;

    public TenantTokenRequestInterceptor(ClientService clientService) {
        this.clientService = clientService;
        log.info("TenantTokenRequestInterceptor initialized");
    }

    public void apply(RequestTemplate template) {
        String token = this.clientService.token();
        if (token != null) {
            log.info("token = " + token);
            template.header(UserType.APPID.tokenKey(), new String[]{token});
        }
    }

    public static TenantTokenRequestInterceptorBuilder builder() {
        return new TenantTokenRequestInterceptorBuilder();
    }

    public static class TenantTokenRequestInterceptorBuilder {
        private ClientService clientService;

        TenantTokenRequestInterceptorBuilder() {
        }

        public TenantTokenRequestInterceptorBuilder clientService(ClientService clientService) {
            this.clientService = clientService;
            return this;
        }

        public TenantTokenRequestInterceptor build() {
            return new TenantTokenRequestInterceptor(this.clientService);
        }

        public String toString() {
            return "TenantTokenRequestInterceptor.TenantTokenRequestInterceptorBuilder(clientService=" + this.clientService + ")";
        }
    }
}

