/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.tenant.security.client.feign.support.OauthClientProperties;
import com.xforceplus.tenant.security.token.domain.UserType;
import io.geewit.web.utils.JsonUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ClientService {
    private static final Logger log = LoggerFactory.getLogger(ClientService.class);
    private final AtomicInteger counter = new AtomicInteger(0);
    private final RestTemplate restTemplate;
    private final OauthClientProperties clientProperties;
    private final LoadingCache<String, String> cache;

    public ClientService(@Qualifier(value="tenantRestTemplate") RestTemplate restTemplate, OauthClientProperties clientProperties) {
        this.restTemplate = restTemplate;
        this.clientProperties = clientProperties;
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(Duration.of(clientProperties.getExpireHours(), ChronoUnit.HOURS)).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(@NotNull String key) {
                return ClientService.this.fetchToken();
            }
        });
        log.info("ClientService initialized");
    }

    public String token() {
        if (this.clientProperties.getParams() == null) {
            log.warn("clientProperties.params == null, return null");
            return null;
        }
        String clientId = this.clientProperties.getParams().getClientId();
        if (StringUtils.isBlank((CharSequence)clientId)) {
            log.warn("clientProperties.params.clientId is blank, return null");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.clientProperties.getParams().getSecret())) {
            log.warn("clientProperties.params.secret is blank, return null");
            return null;
        }
        log.debug("clientProperties.params.clientId = {}", (Object)clientId);
        return (String)this.cache.getUnchecked((Object)clientId);
    }

    public void refresh() {
        log.info("refresh cache");
        this.cache.invalidateAll();
    }

    private String fetchToken() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((Object)this.clientProperties.getParams(), (MultiValueMap)headers);
            log.debug("request.url = {}", (Object)this.clientProperties.getRequestUrl());
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.clientProperties.getRequestUrl(), (Object)request, String.class, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                String body = (String)responseEntity.getBody();
                Map bodyMap = (Map)JsonUtils.fromJson((String)body, (TypeReference)new TypeReference<Map<String, String>>(){});
                String token = (String)bodyMap.get("data");
                log.info("fetch token: {}", (Object)token);
                if (StringUtils.isEmpty((CharSequence)token)) {
                    return this.exceptionFetch("\u672a\u77e5");
                }
                this.counter.set(0);
                return token;
            }
            log.warn("requestUrl: {} failed, (reponse.status: {})", (Object)this.clientProperties.getRequestUrl(), (Object)responseEntity.getStatusCodeValue());
            String body = (String)responseEntity.getBody();
            Map bodyMap = (Map)JsonUtils.fromJson((String)body, (TypeReference)new TypeReference<Map<String, String>>(){});
            String message = (String)bodyMap.get("message");
            return this.exceptionFetch(message);
        }
        catch (RestClientException e) {
            log.warn("requestUrl: {} failed, e: {}", (Object)this.clientProperties.getRequestUrl(), (Object)e.getMessage());
            return this.exceptionFetch(e.getMessage());
        }
    }

    private String exceptionFetch(String message) {
        this.refresh();
        try {
            log.info("sleep 1s");
            Thread.sleep(this.clientProperties.getSleepMillis());
            log.info("fetchToken again");
            int count = this.counter.getAndAdd(1);
            if (count > this.clientProperties.getMaxFailTimes()) {
                this.counter.set(0);
                if (StringUtils.isBlank((CharSequence)message)) {
                    message = "\u65e0\u6cd5\u89e3\u51b3";
                }
                message = "\u53d1\u751f" + message + "\u7684\u9519\u8bef\u5bfc\u81f4\u65e0\u6cd5\u53d6\u5f97" + UserType.APPID.tokenKey();
                log.warn(message);
                throw new RuntimeException(message);
            }
            return this.fetchToken();
        }
        catch (InterruptedException e) {
            log.warn("sleep exception: {}", (Object)e.getMessage());
            return this.fetchToken();
        }
    }
}

