/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.support;

import feign.Contract;
import feign.Feign;
import feign.MethodMetadata;
import feign.Param;
import feign.Request;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.CollectionFormat;
import org.springframework.cloud.openfeign.annotation.MatrixVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.PathVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.QueryMapParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestHeaderParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestParamParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestPartParameterProcessor;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class SpringMvcContract
extends Contract.BaseContract {
    private static final Logger log = LoggerFactory.getLogger(SpringMvcContract.class);
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor ITERABLE_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Iterable.class);
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Map<Class<? extends Annotation>, AnnotatedParameterProcessor> annotatedArgumentProcessors;
    private final Map<String, Method> processedMethods = new HashMap<String, Method>();
    private final ConversionService conversionService;
    private final ConvertingExpanderFactory convertingExpanderFactory;
    private final boolean decodeSlash;
    private final Properties properties;
    private final PropertyPlaceholderHelper helper;
    private final PropertyPlaceholderHelper.PlaceholderResolver resolver;

    public SpringMvcContract(Properties properties) {
        this(Collections.emptyList(), properties);
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, Properties properties) {
        this(annotatedParameterProcessors, (ConversionService)new DefaultConversionService(), properties);
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService, Properties properties) {
        this(annotatedParameterProcessors, conversionService, properties, true);
    }

    public SpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService, Properties properties, boolean decodeSlash) {
        Assert.notNull(annotatedParameterProcessors, (String)"Parameter processors can not be null.");
        Assert.notNull((Object)conversionService, (String)"ConversionService can not be null.");
        List<AnnotatedParameterProcessor> processors = this.getDefaultAnnotatedArgumentsProcessors();
        processors.addAll(annotatedParameterProcessors);
        this.annotatedArgumentProcessors = this.toAnnotatedArgumentProcessorMap(processors);
        this.conversionService = conversionService;
        this.convertingExpanderFactory = new ConvertingExpanderFactory(conversionService);
        this.properties = properties;
        this.decodeSlash = decodeSlash;
        this.helper = new PropertyPlaceholderHelper("${", "}", ":", true);
        this.resolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

            @Nullable
            public String resolvePlaceholder(@NotNull String placeholderName) {
                try {
                    String propVal = SpringMvcContract.this.properties.getProperty(placeholderName);
                    if (propVal == null) {
                        propVal = System.getProperty(placeholderName);
                    }
                    if (propVal == null) {
                        propVal = System.getenv(placeholderName);
                    }
                    return propVal;
                }
                catch (Throwable ex) {
                    log.warn("Could not resolve placeholder '" + placeholderName + "' in properties: " + ex);
                    return null;
                }
            }
        };
    }

    private static TypeDescriptor createTypeDescriptor(Method method, int paramIndex) {
        Parameter parameter = method.getParameters()[paramIndex];
        MethodParameter methodParameter = MethodParameter.forParameter((Parameter)parameter);
        TypeDescriptor typeDescriptor = new TypeDescriptor(methodParameter);
        if (typeDescriptor.isAssignableTo(ITERABLE_TYPE_DESCRIPTOR)) {
            TypeDescriptor elementTypeDescriptor = SpringMvcContract.getElementTypeDescriptor(typeDescriptor);
            Util.checkState((elementTypeDescriptor != null ? 1 : 0) != 0, (String)"Could not resolve element type of Iterable type %s. Not declared?", (Object[])new Object[]{typeDescriptor});
            typeDescriptor = elementTypeDescriptor;
        }
        return typeDescriptor;
    }

    private static TypeDescriptor getElementTypeDescriptor(TypeDescriptor typeDescriptor) {
        TypeDescriptor elementTypeDescriptor = typeDescriptor.getElementTypeDescriptor();
        if (elementTypeDescriptor == null && Iterable.class.isAssignableFrom(typeDescriptor.getType())) {
            ResolvableType type = typeDescriptor.getResolvableType().as(Iterable.class).getGeneric(new int[]{0});
            if (type.resolve() == null) {
                return null;
            }
            return new TypeDescriptor(type, null, typeDescriptor.getAnnotations());
        }
        return elementTypeDescriptor;
    }

    protected void processAnnotationOnClass(MethodMetadata data, Class<?> clz) {
        RequestMapping classAnnotation = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(clz, RequestMapping.class);
        if (classAnnotation != null) {
            log.error("Cannot process class: " + clz.getName() + ". @RequestMapping annotation is not allowed on @FeignClient interfaces.");
            throw new IllegalArgumentException("@RequestMapping annotation not allowed on @FeignClient interfaces");
        }
    }

    public MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        this.processedMethods.put(Feign.configKey(targetType, (Method)method), method);
        return super.parseAndValidateMetadata(targetType, method);
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        String pathValue;
        CollectionFormat collectionFormat;
        if (methodAnnotation instanceof CollectionFormat && (collectionFormat = (CollectionFormat)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CollectionFormat.class)) != null) {
            data.template().collectionFormat(collectionFormat.value());
        }
        if (!(methodAnnotation instanceof RequestMapping) && !methodAnnotation.annotationType().isAnnotationPresent(RequestMapping.class)) {
            return;
        }
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        if (methodMapping == null) {
            return;
        }
        Object[] methods = methodMapping.method();
        if (methods.length == 0) {
            methods = new RequestMethod[]{RequestMethod.GET};
        }
        this.checkOne(method, methods, "method");
        data.template().method(Request.HttpMethod.valueOf((String)methods[0].name()));
        this.checkAtMostOne(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0 && (pathValue = Util.emptyToNull((String)methodMapping.value()[0])) != null) {
            if (!(pathValue = this.resolve(pathValue)).startsWith("/") && !data.template().path().endsWith("/")) {
                pathValue = "/" + pathValue;
            }
            data.template().uri(pathValue, true);
            if (data.template().decodeSlash() != this.decodeSlash) {
                data.template().decodeSlash(this.decodeSlash);
            }
        }
        this.parseProduces(data, method, methodMapping);
        this.parseConsumes(data, method, methodMapping);
        this.parseHeaders(data, method, methodMapping);
        data.indexToExpander(new LinkedHashMap());
    }

    private String resolve(String value) {
        return this.helper.replacePlaceholders(value, this.resolver);
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)"Method %s can only contain at most 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        TypeDescriptor typeDescriptor;
        boolean isHttpAnnotation = false;
        SimpleAnnotatedParameterContext context = new SimpleAnnotatedParameterContext(data, paramIndex);
        Method method = this.processedMethods.get(data.configKey());
        for (Annotation parameterAnnotation : annotations) {
            AnnotatedParameterProcessor processor = this.annotatedArgumentProcessors.get(parameterAnnotation.annotationType());
            if (processor == null) continue;
            Annotation processParameterAnnotation = this.synthesizeWithMethodParameterNameAsFallbackValue(parameterAnnotation, method, paramIndex);
            isHttpAnnotation |= processor.processArgument((AnnotatedParameterProcessor.AnnotatedParameterContext)context, processParameterAnnotation, method);
        }
        if (!this.isMultipartFormData(data) && isHttpAnnotation && data.indexToExpander().get(paramIndex) == null && this.conversionService.canConvert(typeDescriptor = SpringMvcContract.createTypeDescriptor(method, paramIndex), STRING_TYPE_DESCRIPTOR)) {
            Param.Expander expander = this.convertingExpanderFactory.getExpander(typeDescriptor);
            data.indexToExpander().put(paramIndex, expander);
        }
        return isHttpAnnotation;
    }

    private void parseProduces(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientAccepts;
        String[] serverProduces = annotation.produces();
        String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
        if (clientAccepts != null) {
            md.template().header("Accept", new String[]{clientAccepts});
        }
    }

    private void parseConsumes(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientProduces;
        String[] serverConsumes = annotation.consumes();
        String string = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
        if (clientProduces != null) {
            md.template().header("Content-Type", new String[]{clientProduces});
        }
    }

    private void parseHeaders(MethodMetadata md, Method method, RequestMapping annotation) {
        for (String header : annotation.headers()) {
            int index = header.indexOf(61);
            if (header.contains("!=") || index < 0) continue;
            md.template().header(this.resolve(header.substring(0, index)), new String[]{this.resolve(header.substring(index + 1).trim())});
        }
    }

    private Map<Class<? extends Annotation>, AnnotatedParameterProcessor> toAnnotatedArgumentProcessorMap(List<AnnotatedParameterProcessor> processors) {
        return processors.stream().collect(Collectors.toMap(AnnotatedParameterProcessor::getAnnotationType, processor -> processor, (oldKey, newKey) -> newKey));
    }

    private List<AnnotatedParameterProcessor> getDefaultAnnotatedArgumentsProcessors() {
        return Stream.of(new MatrixVariableParameterProcessor(), new PathVariableParameterProcessor(), new RequestParamParameterProcessor(), new RequestHeaderParameterProcessor(), new QueryMapParameterProcessor(), new RequestPartParameterProcessor()).collect(Collectors.toList());
    }

    private Annotation synthesizeWithMethodParameterNameAsFallbackValue(Annotation parameterAnnotation, Method method, int parameterIndex) {
        String[] parameterNames;
        Type[] parameterTypes;
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)parameterAnnotation);
        Object defaultValue = AnnotationUtils.getDefaultValue((Annotation)parameterAnnotation);
        if (defaultValue instanceof String && defaultValue.equals(annotationAttributes.get("value")) && this.shouldAddParameterName(parameterIndex, parameterTypes = method.getGenericParameterTypes(), parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(method))) {
            annotationAttributes.put("value", parameterNames[parameterIndex]);
        }
        return AnnotationUtils.synthesizeAnnotation((Map)annotationAttributes, parameterAnnotation.annotationType(), null);
    }

    private boolean shouldAddParameterName(int parameterIndex, Type[] parameterTypes, String[] parameterNames) {
        return parameterNames != null && parameterNames.length > parameterIndex && parameterTypes != null && parameterTypes.length > parameterIndex;
    }

    private boolean isMultipartFormData(MethodMetadata data) {
        Collection contentTypes = (Collection)data.template().headers().get("Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            String type = (String)contentTypes.iterator().next();
            try {
                return Objects.equals(MediaType.valueOf((String)type), MediaType.MULTIPART_FORM_DATA);
            }
            catch (InvalidMediaTypeException ignored) {
                return false;
            }
        }
        return false;
    }

    private class SimpleAnnotatedParameterContext
    implements AnnotatedParameterProcessor.AnnotatedParameterContext {
        private final MethodMetadata methodMetadata;
        private final int parameterIndex;

        SimpleAnnotatedParameterContext(MethodMetadata methodMetadata, int parameterIndex) {
            this.methodMetadata = methodMetadata;
            this.parameterIndex = parameterIndex;
        }

        public MethodMetadata getMethodMetadata() {
            return this.methodMetadata;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public void setParameterName(String name) {
            SpringMvcContract.this.nameParam(this.methodMetadata, name, this.parameterIndex);
        }

        public Collection<String> setTemplateParameter(String name, Collection<String> rest) {
            Collection params = Optional.ofNullable(rest).map(ArrayList::new).orElse(new ArrayList());
            params.add(String.format("{%s}", name));
            return params;
        }
    }

    private static class ConvertingExpanderFactory {
        private final ConversionService conversionService;

        ConvertingExpanderFactory(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        Param.Expander getExpander(TypeDescriptor typeDescriptor) {
            return value -> {
                Object converted = this.conversionService.convert(value, typeDescriptor, STRING_TYPE_DESCRIPTOR);
                return (String)converted;
            };
        }
    }
}

