/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.tenant.core.exception.TenantFeignException;
import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.client.feign.support.OauthClientProperties;
import com.xforceplus.tenant.security.client.feign.support.PageJacksonModule;
import com.xforceplus.tenant.security.client.feign.support.PageableSpringEncoder;
import com.xforceplus.tenant.security.client.feign.support.SortJacksonModule;
import com.xforceplus.tenant.security.client.feign.support.SpringMvcContract;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.deserializer.OrgTypeDeserializer;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.FeignException;
import feign.Request;
import feign.RequestInterceptor;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.spring.SpringFormEncoder;
import feign.optionals.OptionalDecoder;
import io.geewit.core.jackson.databind.serializer.BigDecimalSerializer;
import io.geewit.core.jackson.databind.serializer.EnumNameSerializer;
import io.geewit.core.jackson.databind.serializer.EnumValueSerializer;
import io.geewit.core.jackson.databind.serializer.JsonPageSerializer;
import io.geewit.core.utils.enums.Name;
import io.geewit.web.convert.converter.DateConverter;
import io.geewit.web.convert.converter.EnumValueConverter;
import io.geewit.web.convert.converter.EnumValueToIntegerConverter;
import io.geewit.web.utils.JsonUtils;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.annotation.MatrixVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.PathVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.QueryMapParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestHeaderParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestParamParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestPartParameterProcessor;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.domain.Page;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class FeignUtils {
    private static final Logger log = LoggerFactory.getLogger(FeignUtils.class);
    public static final List<AnnotatedParameterProcessor> DEFAULT_ANNOTATED_ARGUMENT_RESOLVERS = Stream.of(new MatrixVariableParameterProcessor(), new PathVariableParameterProcessor(), new RequestParamParameterProcessor(), new RequestHeaderParameterProcessor(), new QueryMapParameterProcessor(), new RequestPartParameterProcessor()).collect(Collectors.toList());

    private static Feign.Builder defaultBuilder(Client client, ClientService clientService, Properties properties) {
        DefaultFormattingConversionService formattingConversionService = new DefaultFormattingConversionService();
        return Feign.builder().decoder(FeignUtils.feignDecoder()).errorDecoder(FeignUtils.errorDecoder(clientService)).contract(FeignUtils.feignContract(DEFAULT_ANNOTATED_ARGUMENT_RESOLVERS, (FormattingConversionService)formattingConversionService, properties)).client(client);
    }

    public static Feign.Builder of(Client client, Properties properties) {
        return FeignUtils.defaultBuilder(client, null, properties).encoder(FeignUtils.feignEncoder());
    }

    public static Feign.Builder of(Client client, ClientService clientService, Properties properties) {
        return FeignUtils.defaultBuilder(client, clientService, properties).encoder(FeignUtils.feignEncoder());
    }

    public static Feign.Builder of(Client client, ClientService clientService, ResourceLoader resourceLoader) {
        return FeignUtils.defaultBuilder(client, clientService, FeignUtils.toProperties(resourceLoader)).encoder(FeignUtils.feignEncoder());
    }

    public static Feign.Builder of(Client client, Properties properties, String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        return FeignUtils.of(client, null, properties, pageParameter, sizeParameter, sortParameter, oneIndexedParameters);
    }

    public static Feign.Builder of(Client client, RestTemplate tenantRestTemplate, OauthClientProperties oauthClientProperties, Properties properties, String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        ClientService clientService = new ClientService(tenantRestTemplate, oauthClientProperties);
        return FeignUtils.of(client, clientService, properties, pageParameter, sizeParameter, sortParameter, oneIndexedParameters);
    }

    public static Feign.Builder of(Client client, ClientService clientService, ResourceLoader resourceLoader, String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        Properties properties = FeignUtils.toProperties(resourceLoader);
        Feign.Builder builder = FeignUtils.defaultBuilder(client, clientService, properties);
        builder = builder.encoder((Encoder)FeignUtils.feignEncoderPageable(pageParameter, sizeParameter, sortParameter, oneIndexedParameters));
        return builder;
    }

    public static Feign.Builder of(Client client, ClientService clientService, Properties properties, String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        return FeignUtils.defaultBuilder(client, clientService, properties).encoder((Encoder)FeignUtils.feignEncoderPageable(pageParameter, sizeParameter, sortParameter, oneIndexedParameters));
    }

    public static Feign.Builder builderOption(Feign.Builder builder, FeignClientProperties.FeignClientConfiguration defaultConifg) {
        Integer connectionTimeout = null;
        Integer readTimeout = null;
        if (defaultConifg != null) {
            connectionTimeout = defaultConifg.getConnectTimeout();
            readTimeout = defaultConifg.getReadTimeout();
        }
        if (connectionTimeout == null || connectionTimeout <= 0) {
            connectionTimeout = 10000;
        }
        if (readTimeout == null || readTimeout <= 0) {
            readTimeout = 60000;
        }
        return builder.options(new Request.Options((long)readTimeout.intValue(), TimeUnit.MILLISECONDS, (long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS, true));
    }

    public static Feign.Builder registerRequestInterceptors(Feign.Builder builder, Iterable<RequestInterceptor> requestInterceptors, RequestInterceptor ... extendRequestInterceptors) {
        if (requestInterceptors != null && requestInterceptors.iterator().hasNext()) {
            builder.requestInterceptors(requestInterceptors);
        }
        if (extendRequestInterceptors != null) {
            Arrays.stream(extendRequestInterceptors).forEach(arg_0 -> ((Feign.Builder)builder).requestInterceptor(arg_0));
        }
        return builder;
    }

    public static ObjectFactory<HttpMessageConverters> feignHttpMessageConverter() {
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = mappingJackson2HttpMessageConverter.getObjectMapper();
        PageJacksonModule pageJacksonModule = FeignUtils.pageJacksonModule();
        SortJacksonModule sortJacksonModule = FeignUtils.sortJacksonModule();
        objectMapper.registerModule((Module)pageJacksonModule);
        objectMapper.registerModule((Module)sortJacksonModule);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(OrgType.class, (JsonSerializer)EnumValueSerializer.instanceOfInteger);
        simpleModule.addSerializer(Name.class, (JsonSerializer)EnumNameSerializer.instance);
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)BigDecimalSerializer.instance);
        simpleModule.addSerializer(Page.class, (JsonSerializer)new JsonPageSerializer(objectMapper));
        simpleModule.addDeserializer(OrgType.class, (JsonDeserializer)OrgTypeDeserializer.instance);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.registerModule((Module)simpleModule);
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{mappingJackson2HttpMessageConverter});
        return () -> httpMessageConverters;
    }

    public static Decoder feignDecoder() {
        return new OptionalDecoder((Decoder)new ResponseEntityDecoder((Decoder)new SpringDecoder(FeignUtils.feignHttpMessageConverter())));
    }

    public static ErrorDecoder errorDecoder(ClientService clientService) {
        return (methodKey, response) -> {
            Request request;
            if (clientService != null && response.status() == HttpStatus.UNAUTHORIZED.value()) {
                clientService.refresh();
            }
            if ((request = response.request()) != null) {
                String requestUrl = request.url();
                String requestMethod = request.httpMethod().name();
                Map requestHeaders = request.headers();
                log.error("request url:{}, method:{}, headers:{}", new Object[]{requestUrl, requestMethod, JsonUtils.toJson((Object)requestHeaders)});
                if (request.body() != null) {
                    String requestBody = new String(request.body(), StandardCharsets.UTF_8);
                    log.error("request.body:{}", (Object)requestBody);
                }
            }
            if (response.body() != null) {
                try {
                    String responseBody = Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8));
                    log.debug("responseBody = {}", (Object)responseBody);
                    if (response.status() >= HttpStatus.BAD_REQUEST.value() && response.status() < HttpStatus.INTERNAL_SERVER_ERROR.value()) {
                        log.error("response status: {}, body: {}", (Object)response.status(), (Object)responseBody);
                        throw new TenantFeignException("CLIENT", responseBody, response.status());
                    }
                }
                catch (IOException e) {
                    log.error("\u83b7\u53d6\u8fd4\u56de\u503c\u53d1\u751f\u9519\u8bef");
                }
            }
            return FeignException.errorStatus((String)methodKey, (Response)response);
        };
    }

    public static Encoder feignEncoder() {
        return new SpringEncoder(new SpringFormEncoder(), FeignUtils.feignHttpMessageConverter());
    }

    public static PageableSpringEncoder feignEncoderPageable(String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        PageableSpringEncoder encoder = new PageableSpringEncoder(FeignUtils.feignEncoder());
        encoder.setPageParameter(pageParameter);
        encoder.setSizeParameter(sizeParameter);
        encoder.setSortParameter(sortParameter);
        encoder.setOneIndexedParameters(oneIndexedParameters);
        return encoder;
    }

    public static PageJacksonModule pageJacksonModule() {
        return new PageJacksonModule();
    }

    public static SortJacksonModule sortJacksonModule() {
        return new SortJacksonModule();
    }

    public static void addConverters(FormattingConversionService feignConversionService) {
        feignConversionService.addConverter(String.class, OrgType.class, (Converter)new EnumValueConverter());
        feignConversionService.addConverter(Long.class, OrgType.class, (Converter)new EnumValueConverter());
        feignConversionService.addConverter(Long.TYPE, OrgType.class, (Converter)new EnumValueConverter());
        feignConversionService.addConverter(OrgType.class, Integer.class, (Converter)new EnumValueToIntegerConverter());
        feignConversionService.addConverter(String.class, Date.class, (Converter)new DateConverter());
    }

    public static Contract feignContract(List<AnnotatedParameterProcessor> parameterProcessors, FormattingConversionService feignConversionService, Properties properties) {
        return new SpringMvcContract(parameterProcessors, (ConversionService)feignConversionService, properties);
    }

    public static Properties toProperties(ResourceLoader resourceLoader) {
        Properties properties = new Properties();
        if (resourceLoader instanceof ConfigurableApplicationContext) {
            MutablePropertySources propertySources = ((ConfigurableApplicationContext)resourceLoader).getEnvironment().getPropertySources();
            for (PropertySource propertySource : propertySources) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                Arrays.stream(enumerablePropertySource.getPropertyNames()).forEach(propertyName -> properties.setProperty((String)propertyName, Objects.requireNonNull(enumerablePropertySource.getProperty(propertyName)).toString()));
            }
        }
        return properties;
    }
}

