/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.support;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableSpringEncoder
implements Encoder {
    private final Encoder delegate;
    private static final String DEFAULT_SORT_PARAMETER = "sort";
    private String pageParameter = "page";
    private String sizeParameter = "size";
    private String sortParameter = "sort";
    private boolean oneIndexedParameters = false;

    public PageableSpringEncoder(Encoder delegate) {
        this.delegate = delegate;
    }

    public void setPageParameter(String pageParameter) {
        this.pageParameter = pageParameter;
    }

    public void setSizeParameter(String sizeParameter) {
        this.sizeParameter = sizeParameter;
    }

    public void setSortParameter(String sortParameter) {
        this.sortParameter = sortParameter;
    }

    public void setOneIndexedParameters(boolean oneIndexedParameters) {
        this.oneIndexedParameters = oneIndexedParameters;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (this.supports(object)) {
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                if (pageable.isPaged()) {
                    template.query(this.pageParameter, new String[]{(this.oneIndexedParameters ? pageable.getPageNumber() + 1 : pageable.getPageNumber()) + ""});
                    template.query(this.sizeParameter, new String[]{pageable.getPageSize() + ""});
                }
                this.applySort(template, pageable.getSort());
            } else if (object instanceof Sort) {
                Sort sort = (Sort)object;
                this.applySort(template, sort);
            }
        } else if (this.delegate != null) {
            this.delegate.encode(object, bodyType, template);
        } else {
            throw new EncodeException("PageableSpringEncoder does not support the given object " + object.getClass() + " and no delegate was provided for fallback!");
        }
    }

    private void applySort(RequestTemplate template, Sort sort) {
        ArrayList<String> sortQueries;
        Collection existingSorts = (Collection)template.queries().get(DEFAULT_SORT_PARAMETER);
        ArrayList<String> arrayList = sortQueries = existingSorts != null ? new ArrayList<String>(existingSorts) : new ArrayList();
        if (!DEFAULT_SORT_PARAMETER.equals(this.sortParameter) && (existingSorts = (Collection)template.queries().get(this.sortParameter)) != null) {
            sortQueries.addAll(existingSorts);
        }
        for (Sort.Order order : sort) {
            sortQueries.add(order.getProperty() + "," + order.getDirection());
        }
        if (!sortQueries.isEmpty()) {
            template.query(this.sortParameter, sortQueries);
        }
    }

    protected boolean supports(Object object) {
        return object instanceof Pageable || object instanceof Sort;
    }
}

