/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.interceptor;

import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.token.domain.UserType;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantTokenRequestInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TenantTokenRequestInterceptor.class);
    private ClientService clientService;

    public TenantTokenRequestInterceptor(ClientService clientService) {
        this.clientService = clientService;
        logger.info("TenantTokenRequestInterceptor initialized");
    }

    public void apply(RequestTemplate template) {
        String token = this.clientService.token();
        if (token != null) {
            logger.info("token = " + token);
            template.header(UserType.APPID.tokenKey(), new String[]{token});
        }
    }
}

