/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.feign.utils;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.tenant.core.exception.TenantFeignException;
import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.tenant.security.client.feign.support.PageJacksonModule;
import com.xforceplus.tenant.security.client.feign.support.PageableSpringEncoder;
import com.xforceplus.tenant.security.client.feign.support.SortJacksonModule;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.deserializer.OrgTypeDeserializer;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.FeignException;
import feign.Request;
import feign.RequestInterceptor;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.spring.SpringFormEncoder;
import feign.optionals.OptionalDecoder;
import io.geewit.core.jackson.databind.serializer.BigDecimalSerializer;
import io.geewit.core.jackson.databind.serializer.EnumNameSerializer;
import io.geewit.core.jackson.databind.serializer.EnumValueSerializer;
import io.geewit.core.jackson.databind.serializer.JsonPageSerializer;
import io.geewit.core.utils.enums.Name;
import io.geewit.web.convert.converter.DateConverter;
import io.geewit.web.convert.converter.EnumValueConverter;
import io.geewit.web.convert.converter.EnumValueToIntegerConverter;
import io.geewit.web.utils.JsonUtils;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.annotation.MatrixVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.PathVariableParameterProcessor;
import org.springframework.cloud.openfeign.annotation.QueryMapParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestHeaderParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestParamParameterProcessor;
import org.springframework.cloud.openfeign.annotation.RequestPartParameterProcessor;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.domain.Page;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class FeignUtils {
    private static final Logger logger = LoggerFactory.getLogger(FeignUtils.class);
    private static final String PASSWORD = "password";
    private static final String SEPARATOR = "\\?";

    private static Feign.Builder defaultBuilder(Client client, ResourceLoader resourceLoader, ClientService clientService) {
        ArrayList<AnnotatedParameterProcessor> annotatedArgumentResolvers = new ArrayList<AnnotatedParameterProcessor>();
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new MatrixVariableParameterProcessor());
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new PathVariableParameterProcessor());
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new RequestParamParameterProcessor());
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new RequestHeaderParameterProcessor());
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new QueryMapParameterProcessor());
        annotatedArgumentResolvers.add((AnnotatedParameterProcessor)new RequestPartParameterProcessor());
        DefaultFormattingConversionService formattingConversionService = new DefaultFormattingConversionService();
        return Feign.builder().decoder(FeignUtils.feignDecoder()).errorDecoder(FeignUtils.errorDecoder(clientService)).contract(FeignUtils.feignContract(resourceLoader, annotatedArgumentResolvers, (FormattingConversionService)formattingConversionService)).client(client);
    }

    public static Feign.Builder of(Client client, ResourceLoader resourceLoader) {
        Feign.Builder builder = FeignUtils.defaultBuilder(client, resourceLoader, null);
        builder = builder.encoder(FeignUtils.feignEncoder());
        return builder;
    }

    public static Feign.Builder of(Client client, ResourceLoader resourceLoader, ClientService clientService) {
        Feign.Builder builder = FeignUtils.defaultBuilder(client, resourceLoader, clientService);
        builder = builder.encoder(FeignUtils.feignEncoder());
        return builder;
    }

    public static Feign.Builder of(Client client, ResourceLoader resourceLoader, String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        Feign.Builder builder = FeignUtils.defaultBuilder(client, resourceLoader, null);
        builder = builder.encoder((Encoder)FeignUtils.feignEncoderPageable(pageParameter, sizeParameter, sortParameter, oneIndexedParameters));
        return builder;
    }

    public static Feign.Builder of(Client client, ResourceLoader resourceLoader, ClientService clientService, String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        Feign.Builder builder = FeignUtils.defaultBuilder(client, resourceLoader, clientService);
        builder = builder.encoder((Encoder)FeignUtils.feignEncoderPageable(pageParameter, sizeParameter, sortParameter, oneIndexedParameters));
        return builder;
    }

    public static Feign.Builder builderOption(Feign.Builder builder, FeignClientProperties.FeignClientConfiguration defaultConifg) {
        Integer connectionTimeout = null;
        Integer readTimeout = null;
        if (defaultConifg != null) {
            connectionTimeout = defaultConifg.getConnectTimeout();
            readTimeout = defaultConifg.getReadTimeout();
        }
        if (connectionTimeout == null || connectionTimeout <= 0) {
            connectionTimeout = 10000;
        }
        if (readTimeout == null || readTimeout <= 0) {
            readTimeout = 60000;
        }
        return builder.options(new Request.Options((long)readTimeout.intValue(), TimeUnit.MILLISECONDS, (long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS, true));
    }

    public static Feign.Builder registerRequestInterceptors(Feign.Builder builder, Iterable<RequestInterceptor> requestInterceptors, RequestInterceptor ... extendRequestInterceptors) {
        if (requestInterceptors != null && requestInterceptors.iterator().hasNext()) {
            builder = builder.requestInterceptors(requestInterceptors);
        }
        if (extendRequestInterceptors != null && extendRequestInterceptors.length > 0) {
            for (RequestInterceptor extendRequestInterceptor : extendRequestInterceptors) {
                builder = builder.requestInterceptor(extendRequestInterceptor);
            }
        }
        return builder;
    }

    public static ObjectFactory<HttpMessageConverters> feignHttpMessageConverter() {
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = mappingJackson2HttpMessageConverter.getObjectMapper();
        PageJacksonModule pageJacksonModule = FeignUtils.pageJacksonModule();
        SortJacksonModule sortJacksonModule = FeignUtils.sortJacksonModule();
        objectMapper.registerModule((Module)pageJacksonModule);
        objectMapper.registerModule((Module)sortJacksonModule);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(OrgType.class, (JsonSerializer)EnumValueSerializer.instance);
        simpleModule.addSerializer(Name.class, (JsonSerializer)EnumNameSerializer.instance);
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)BigDecimalSerializer.instance);
        simpleModule.addSerializer(Page.class, (JsonSerializer)new JsonPageSerializer(objectMapper));
        simpleModule.addDeserializer(OrgType.class, (JsonDeserializer)OrgTypeDeserializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{mappingJackson2HttpMessageConverter});
        return () -> httpMessageConverters;
    }

    public static Decoder feignDecoder() {
        return new OptionalDecoder((Decoder)new ResponseEntityDecoder((Decoder)new SpringDecoder(FeignUtils.feignHttpMessageConverter())));
    }

    public static ErrorDecoder errorDecoder(ClientService clientService) {
        return (methodKey, response) -> {
            Request request;
            if (clientService != null && response.status() == HttpStatus.UNAUTHORIZED.value()) {
                clientService.refresh();
            }
            if ((request = response.request()) != null) {
                String requestUrl = request.url();
                String requestMethod = request.httpMethod().name();
                Map requestHeaders = request.headers();
                logger.error("request url:{}, method:{}, headers:{}", new Object[]{requestUrl, requestMethod, JsonUtils.toJson((Object)requestHeaders)});
                if (request.body() != null) {
                    String requestBody = new String(request.body(), StandardCharsets.UTF_8);
                    logger.error("request.body:{}", (Object)requestBody);
                }
            }
            if (response.body() != null) {
                try {
                    String responseBody = Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8));
                    logger.debug("responseBody = {}", (Object)responseBody);
                    if (response.status() >= HttpStatus.BAD_REQUEST.value() && response.status() < HttpStatus.INTERNAL_SERVER_ERROR.value()) {
                        logger.error("response status: {}, body: {}", (Object)response.status(), (Object)responseBody);
                        throw new TenantFeignException("CLIENT", responseBody, response.status());
                    }
                }
                catch (IOException e) {
                    logger.error("\u83b7\u53d6\u8fd4\u56de\u503c\u53d1\u751f\u9519\u8bef");
                }
            }
            return FeignException.errorStatus((String)methodKey, (Response)response);
        };
    }

    public static Encoder feignEncoder() {
        return new SpringEncoder(new SpringFormEncoder(), FeignUtils.feignHttpMessageConverter());
    }

    public static PageableSpringEncoder feignEncoderPageable(String pageParameter, String sizeParameter, String sortParameter, Boolean oneIndexedParameters) {
        PageableSpringEncoder encoder = new PageableSpringEncoder(FeignUtils.feignEncoder());
        encoder.setPageParameter(pageParameter);
        encoder.setSizeParameter(sizeParameter);
        encoder.setSortParameter(sortParameter);
        encoder.setOneIndexedParameters(oneIndexedParameters);
        return encoder;
    }

    public static PageJacksonModule pageJacksonModule() {
        return new PageJacksonModule();
    }

    public static SortJacksonModule sortJacksonModule() {
        return new SortJacksonModule();
    }

    public static void addConverters(FormattingConversionService feignConversionService) {
        feignConversionService.addConverter(String.class, OrgType.class, (Converter)new EnumValueConverter());
        feignConversionService.addConverter(Integer.class, OrgType.class, (Converter)new EnumValueConverter());
        feignConversionService.addConverter(Integer.TYPE, OrgType.class, (Converter)new EnumValueConverter());
        feignConversionService.addConverter(OrgType.class, Integer.class, (Converter)new EnumValueToIntegerConverter());
        feignConversionService.addConverter(String.class, Date.class, (Converter)new DateConverter());
    }

    public static Contract feignContract(ResourceLoader resourceLoader, List<AnnotatedParameterProcessor> parameterProcessors, FormattingConversionService feignConversionService) {
        SpringMvcContract contract = new SpringMvcContract(parameterProcessors, (ConversionService)feignConversionService);
        contract.setResourceLoader(resourceLoader);
        return contract;
    }

    private static String handleUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        String[] strings = url.split(SEPARATOR);
        if (strings.length != 2) {
            return url;
        }
        String queryString = strings[1];
        queryString = FeignUtils.filterSensitiveLog(queryString);
        return strings[0] + "?" + queryString;
    }

    private static String filterSensitiveLog(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        if (!source.contains(PASSWORD)) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        String[] elements = source.split("&");
        Arrays.stream(elements).forEach(item -> {
            String[] kv = item.split("=");
            if (!kv[0].equals(PASSWORD)) {
                sb.append((String)item).append("&");
            } else {
                sb.append("pwdlength").append("=");
                if (kv.length < 2) {
                    sb.append(0).append("&");
                } else {
                    if (StringUtils.isNotBlank((CharSequence)kv[1])) {
                        sb.append(kv[1].length());
                    } else {
                        sb.append(0);
                    }
                    sb.append("&");
                }
            }
        });
        return sb.toString();
    }

    public static void main(String[] args) {
        String url = "http://localhost:8080/api/users/get?uid=1&name=zombie&email=&phone=182177";
        url = FeignUtils.handleUrl(url);
        System.out.println(url);
    }
}

