package com.xforceplus.tenant.security.client.config;

import com.xforceplus.tenant.security.client.factory.ConnectionPoolFactory;
import com.xforceplus.tenant.security.client.factory.OkHttpClientFactory;
import com.xforceplus.tenant.security.client.support.OkHttpProperties;
import lombok.extern.slf4j.Slf4j;
import okhttp3.ConnectionPool;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;


/**
 * @author geewit
 */
@Slf4j
@Configuration(value = "tenantOkHttpConfiguration", proxyBeanMethods = false)
@EnableConfigurationProperties({OkHttpProperties.class})
public class TenantOkHttpConfiguration {

    public TenantOkHttpConfiguration() {
        log.info("tenant-security.TenantOkHttpConfiguration initialized");
    }

    @Bean
    @ConditionalOnMissingBean(ConnectionPool.class)
    public ConnectionPool httpClientConnectionPool(
            OkHttpProperties okHttpProperties) {
        return ConnectionPoolFactory.createConnectionPool(okHttpProperties);
    }

    @Primary
    @Bean(name = "tenantOkHttpClient")
    public okhttp3.OkHttpClient client(ConnectionPool connectionPool,
                                       OkHttpProperties okHttpProperties) {
        return OkHttpClientFactory.createOkHttpClient(connectionPool, okHttpProperties);
    }


}
