package com.xforceplus.tenant.security.client.factory;

import com.xforceplus.tenant.security.client.support.OkHttpProperties;
import okhttp3.ConnectionPool;

import java.util.concurrent.TimeUnit;

/**
 * ConnectionPoolFactory
 * @author geewit
 */
public class ConnectionPoolFactory {
    public static ConnectionPool createConnectionPool(OkHttpProperties okHttpProperties) {
        int maxTotalConnections = okHttpProperties.getMaxConnections();
        long timeToLive = okHttpProperties.getTimeToLive();
        TimeUnit timeUnit = okHttpProperties.getTimeToLiveUnit();
        return new ConnectionPool(maxTotalConnections, timeToLive, timeUnit);
    }
}
