/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.config;

import com.xforceplus.tenant.security.client.factory.ConnectionPoolFactory;
import com.xforceplus.tenant.security.client.factory.OkHttpClientFactory;
import com.xforceplus.tenant.security.client.support.OkHttpProperties;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(value="tenantOkHttpConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={OkHttpProperties.class})
public class TenantOkHttpConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TenantOkHttpConfiguration.class);

    public TenantOkHttpConfiguration() {
        log.info("tenant-security.TenantOkHttpConfiguration initialized");
    }

    @Bean
    @ConditionalOnMissingBean(value={ConnectionPool.class})
    public ConnectionPool httpClientConnectionPool(OkHttpProperties okHttpProperties) {
        return ConnectionPoolFactory.createConnectionPool(okHttpProperties);
    }

    @Primary
    @Bean(name={"tenantOkHttpClient"})
    public OkHttpClient client(ConnectionPool connectionPool, OkHttpProperties okHttpProperties) {
        return OkHttpClientFactory.createOkHttpClient(connectionPool, okHttpProperties);
    }
}

