/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.client.factory;

import com.xforceplus.tenant.security.client.support.OkHttpProperties;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClientFactory.class);

    public static OkHttpClient createOkHttpClient(ConnectionPool connectionPool, OkHttpProperties okHttpProperties) {
        boolean followRedirects = okHttpProperties.isFollowRedirects();
        int connectTimeout = okHttpProperties.getConnectionTimeout();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (okHttpProperties.isDisableSslValidation()) {
            try {
                X509TrustManager disabledTrustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                };
                TrustManager[] trustManagers = new TrustManager[]{disabledTrustManager};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, disabledTrustManager);
                builder.hostnameVerifier((s, sslSession) -> true);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                log.warn("Error setting SSLSocketFactory in OKHttpClient", (Throwable)e);
            }
        }
        OkHttpClient okHttpClient = builder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).followRedirects(followRedirects).connectionPool(connectionPool).build();
        return okHttpClient;
    }
}

