package com.xforceplus.tenant.security.client.config;

import com.xforceplus.tenant.security.client.support.OkHttpProperties;
import lombok.extern.slf4j.Slf4j;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;

/**
 * @author geewit
 */
@Slf4j
@Configuration(value = "tenantOkHttpConfiguration", proxyBeanMethods = false)
@EnableConfigurationProperties({OkHttpProperties.class})
public class TenantOkHttpConfiguration {

    public TenantOkHttpConfiguration() {
        log.info("tenant-security.TenantOkHttpConfiguration initialized");
    }

    @Bean
    @ConditionalOnMissingBean(ConnectionPool.class)
    public ConnectionPool httpClientConnectionPool(
            OkHttpProperties okHttpProperties) {
        int maxTotalConnections = okHttpProperties.getMaxConnections();
        long timeToLive = okHttpProperties.getTimeToLive();
        TimeUnit timeUnit = okHttpProperties.getTimeToLiveUnit();
        return new ConnectionPool(maxTotalConnections, timeToLive, timeUnit);
    }

    @Primary
    @Bean(name = "tenantOkHttpClient")
    public okhttp3.OkHttpClient client(ConnectionPool connectionPool,
                                       OkHttpProperties okHttpProperties) {

        boolean followRedirects = okHttpProperties.isFollowRedirects();
        int connectTimeout = okHttpProperties.getConnectionTimeout();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (okHttpProperties.isDisableSslValidation()) {
            try {
                X509TrustManager disabledTrustManager = new X509TrustManager() {
                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                };
                TrustManager[] trustManagers = new TrustManager[1];
                trustManagers[0] = disabledTrustManager;
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, new java.security.SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, disabledTrustManager);
                builder.hostnameVerifier((s, sslSession) -> true);
            } catch (NoSuchAlgorithmException | KeyManagementException e) {
                log.warn("Error setting SSLSocketFactory in OKHttpClient", e);
            }
        }
        okhttp3.OkHttpClient tenantOkHttpClient = builder.connectTimeout(connectTimeout, TimeUnit.MILLISECONDS)
                .followRedirects(followRedirects).connectionPool(connectionPool).build();
        return tenantOkHttpClient;
    }


}
