package com.xforceplus.tenant.security.client.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

/**
 * @author geewit
 */
@AutoConfigureAfter({TenantOkHttpConfiguration.class})
@Configuration(proxyBeanMethods = false)
public class TenantRestTemplateConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TenantRestTemplateConfiguration.class);

    public TenantRestTemplateConfiguration() {
        logger.info("tenant-security.TenantRestTemplateConfiguration initialized");
    }

    @Bean(name = "tenantRestTemplate")
    public RestTemplate tenantRestTemplate(@Qualifier(value = "tenantOkHttpClient") okhttp3.OkHttpClient tenantOkHttpClient) {
        return new RestTemplate(new OkHttp3ClientHttpRequestFactory(tenantOkHttpClient));
    }
}
