package com.xforceplus.tenant.security.logger.webflux.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.config.WebFluxConfigurationSupport;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import com.xforceplus.tenant.security.logger.webflux.filter.RequestLoggerFilter;

/**
 * @author geewit
 */
@Slf4j
@Configuration(proxyBeanMethods = false)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(WebFluxConfigurer.class)
@ConditionalOnMissingBean({ WebFluxConfigurationSupport.class })
@AutoConfigureAfter({ WebFluxAutoConfiguration.class })
public class WebFluxLoggerAutoConfiguration {
    public WebFluxLoggerAutoConfiguration() {
        log.info("tenant-security.WebFluxLoggerAutoConfiguration initialized");
    }

    @Bean
    @ConditionalOnMissingBean(RequestLoggerFilter.class)
    @ConditionalOnProperty(prefix = "xforce.tenant.security.logger.webflux", name = "enabled", matchIfMissing = false)
    public RequestLoggerFilter requestLoggerFilter() {
        log.info("logger init bean:RequestLoggerFilter");
        return new RequestLoggerFilter();
    }
}
