package com.xforceplus.tenant.security.logger.webflux.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.config.WebFluxConfigurationSupport;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import com.xforceplus.tenant.security.logger.webflux.filter.RequestLoggerFilter;

/**
 * @author geewit
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(WebFluxConfigurer.class)
@ConditionalOnMissingBean({ WebFluxConfigurationSupport.class })
@AutoConfigureAfter({ WebFluxAutoConfiguration.class })
public class WebFluxLoggerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WebFluxLoggerAutoConfiguration.class);

    public WebFluxLoggerAutoConfiguration() {
        logger.info("tenant-security.WebFluxLoggerAutoConfiguration initialized");
    }

    @Bean
    @ConditionalOnMissingBean(RequestLoggerFilter.class)
    @ConditionalOnProperty(prefix = "xforce.tenant.security.logger.webflux", name = "enabled", matchIfMissing = false)
    public RequestLoggerFilter requestLoggerFilter() {
        logger.info("logger init bean:RequestLoggerFilter");
        return new RequestLoggerFilter();
    }
}
