/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.config;

import com.xforceplus.tenant.security.logger.web.interceptor.RequestLoggerInterceptor;
import com.xforceplus.tenant.security.server.interceptor.UserContextInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnExpression(value="${xforce.tenant.security.adapter.interceptors.enable:true}")
@Configuration
public class WebMvcInterceptorConfig
implements WebMvcConfigurer,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcInterceptorConfig.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.info("adapter WebMvcInterceptorConfig setting ApplicationContext");
        this.applicationContext = applicationContext;
    }

    public WebMvcInterceptorConfig() {
        logger.info("adapter WebMvcInterceptorConfig initialized");
    }

    public UserContextInterceptor userContextInterceptor() {
        logger.info("adapter init bean:UserContextInterceptor");
        return new UserContextInterceptor(this.applicationContext);
    }

    public RequestLoggerInterceptor requestLoggerInterceptor() {
        logger.info("adapter init bean:RequestLoggerInterceptor");
        return new RequestLoggerInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        logger.info("adapter registry interceptor:RequestLoggerInterceptor");
        registry.addInterceptor((HandlerInterceptor)this.userContextInterceptor());
        boolean loggerEnable = (Boolean)this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.adapter.interceptors.logger.enable", Boolean.class, (Object)false);
        if (loggerEnable) {
            logger.info("adapter registry interceptor:RequestLoggerInterceptor");
            registry.addInterceptor((HandlerInterceptor)this.requestLoggerInterceptor());
        }
    }
}

