/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.interceptor;

import com.auth0.jwt.exceptions.TokenExpiredException;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.domain.user.view.ExtraInfo;
import com.xforceplus.feign.global.user.UserFeignClient;
import com.xforceplus.tenant.security.core.annotation.NeedExtraInfo;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.core.utils.RequestUtils;
import com.xforceplus.tenant.security.server.service.AuthorizedService;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import com.xforceplus.tenant.security.token.domain.UserType;
import io.geewit.core.utils.enums.BinaryUtils;
import io.geewit.core.utils.reflection.BeanUtils;
import io.geewit.web.utils.JsonUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.WebUtils;

public class UserContextInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UserContextInterceptor.class);
    private ApplicationContext applicationContext;

    public UserContextInterceptor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        String token;
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        boolean isStaticPage = RequestUtils.isStaticPage((String)request.getRequestURI());
        if (isStaticPage) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)UserType.USER.tokenKey());
        if (tokenCookie != null) {
            token = tokenCookie.getValue();
        } else {
            logger.warn("Cookie\u4e2d\u65e0token");
            token = request.getHeader(UserType.USER.tokenKey());
            if (StringUtils.isEmpty((CharSequence)token)) {
                logger.warn("Header\u4e2d\u65e0token");
                token = WebUtils.findParameterValue((ServletRequest)request, (String)UserType.USER.tokenKey());
            }
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            logger.warn("token isBlank, " + message);
        }
        Map claims = null;
        String secret = this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.jwt.secret", "my_sessionjw_tsecret_xdfdffdsdfdfs_fat");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                claims = JwtUtils.verifyAndDecodeToken((String)secret, (String)token);
            }
            catch (TokenExpiredException e) {
                logger.error("token\u8fc7\u671f\u5f02\u5e38TokenExpiredException,token=={}", (Object)token);
                String message = "token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
                logger.warn(message);
                return true;
            }
            catch (Exception e) {
                String message = "token\u89e3\u6790\u5931\u8d25";
                logger.error(message + ", secret = " + secret + ", token=" + token, (Throwable)e);
                return true;
            }
        }
        if (claims == null) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            logger.warn("claims == null, " + message);
            return true;
        }
        String systemType = (String)claims.get("type");
        if (!UserType.USER.value().equals(systemType)) {
            String message = "token\u975e\u6cd5\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            logger.warn("claims == null, " + message);
            this.responseUnauthorized(message, request, response);
            return true;
        }
        String encodedUserInfo = (String)claims.get("userinfo");
        if (StringUtils.isBlank((CharSequence)encodedUserInfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            logger.warn("userinfo isBlank, " + message);
            return true;
        }
        String userinfo = CompressionUtils.decode((String)encodedUserInfo);
        if (StringUtils.isBlank((CharSequence)userinfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            logger.warn("userinfo == null, " + message);
            return true;
        }
        try {
            return this.setUserInfoHolder(userinfo, token, method);
        }
        catch (Exception e) {
            String message = "\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38";
            logger.error(message, (Throwable)e);
            return true;
        }
    }

    private <TR extends TokenRole, OO extends OrgDto<OO, E>, RR extends RoleDto, E extends OrgExtensionDto> boolean setUserInfoHolder(String userinfo, String token, HandlerMethod method) {
        logger.info("token = {}, userinfo = {}", (Object)token, (Object)userinfo);
        TokenUser tokenUser = (TokenUser)JsonUtils.fromJson((String)userinfo, TokenUser.class);
        if (tokenUser == null) {
            logger.warn("userinfo = " + userinfo);
            return false;
        }
        tokenUser.setToken(token);
        AuthorizedUser authorizedUser = new AuthorizedUser();
        BeanUtils.copyProperties((Object)tokenUser, (Object)authorizedUser);
        if (!tokenUser.isMock()) {
            int extraInfoDimension;
            NeedExtraInfo needExtraInfo = (NeedExtraInfo)method.getMethodAnnotation(NeedExtraInfo.class);
            EnumSet<ExtraInfo> extraInfoEnumSet = EnumSet.noneOf(ExtraInfo.class);
            if (needExtraInfo != null) {
                if (needExtraInfo.orgs()) {
                    extraInfoEnumSet.add(ExtraInfo.orgs);
                }
                if (needExtraInfo.companies()) {
                    extraInfoEnumSet.add(ExtraInfo.companies);
                }
                if (needExtraInfo.resources()) {
                    extraInfoEnumSet.add(ExtraInfo.resources);
                }
                if (needExtraInfo.currentOrgs()) {
                    extraInfoEnumSet.add(ExtraInfo.currentOrgs);
                }
                if (needExtraInfo.parentCompanies()) {
                    extraInfoEnumSet.add(ExtraInfo.parentCompanies);
                }
                if (needExtraInfo.parentOrgs()) {
                    extraInfoEnumSet.add(ExtraInfo.parentOrgs);
                }
            }
            if ((extraInfoDimension = BinaryUtils.toBinary(extraInfoEnumSet)) > 0) {
                UserFeignClient userFeignClient = (UserFeignClient)this.applicationContext.getBean(UserFeignClient.class);
                AuthorizedService authorizedService = new AuthorizedService(userFeignClient);
                authorizedUser = authorizedService.userInfo(authorizedUser, extraInfoDimension);
            }
        }
        UserInfoHolder.put((IAuthorizedUser)authorizedUser);
        return true;
    }

    private void responseUnauthorized(String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isAjaxRequest = RequestUtils.isAjaxRequest((HttpServletRequest)request);
        String loginUrl = this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.authority.loginUrl", "");
        logger.info("loginUrl = " + loginUrl);
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)loginUrl).build();
        String loginURI = uriComponents.toUriString();
        if (isAjaxRequest) {
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentType("application/json");
            response.setStatus(401);
            LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
            error.put("code", "0");
            error.put("message", message);
            error.put("loginUrl", loginURI);
            response.getWriter().write(JsonUtils.toJson(error));
        } else {
            response.sendRedirect(loginURI);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserInfoHolder.clearContext();
    }
}

