package com.xforceplus.tenant.security.server.adapter;

import com.xforceplus.tenant.security.token.domain.UserType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * @author geewit
 */
public class RequestTokenUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestTokenUtils.class);

    public static String getToken(HttpServletRequest request) {

        String token = request.getHeader(UserType.USER.tokenKey());
        if (StringUtils.isEmpty(token)) {
            logger.warn("Header中无token");
            token = WebUtils.findParameterValue(request, UserType.USER.tokenKey());
        }
        if (StringUtils.isEmpty(token)) {
            logger.warn("Param中无token");
            Cookie tokenCookie = WebUtils.getCookie(request, UserType.USER.tokenKey());
            if (tokenCookie != null) {
                token = tokenCookie.getValue();
            }
        }
        logger.warn("token = {}", token);
        return token;
    }

}
