package com.xforceplus.tenant.security.server.config;

import com.xforceplus.tenant.security.client.config.TenantFeignConfiguration;
import com.xforceplus.tenant.security.server.interceptor.UserContextInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 自动配置spring mvc的拦截器
 * @author:      黄方
 * @since :       2019/05/13
 */
@AutoConfigureAfter({TenantFeignConfiguration.class})
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@Configuration
@ConditionalOnExpression("${xforce.tenant.security.starter.interceptors.enable:true}")
public class TenantUserInterceptorConfig implements WebMvcConfigurer, ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantUserInterceptorConfig.class);

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.info("starter UserContextInterceptor loading");
        this.applicationContext = applicationContext;
    }

    public TenantUserInterceptorConfig() {
        logger.info("starter WebMvcInterceptorConfig initialized");
    }

    private UserContextInterceptor userContextInterceptor() {
        return new UserContextInterceptor(this.applicationContext);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        logger.info("registry interceptor:UserContextInterceptor");
        registry.addInterceptor(userContextInterceptor()).order(Integer.MAX_VALUE);
    }
}
