/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.adapter;

import com.xforceplus.tenant.security.token.domain.UserType;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class RequestTokenUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestTokenUtils.class);

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(UserType.USER.tokenKey());
        if (StringUtils.isEmpty((CharSequence)token)) {
            logger.warn("Header\u4e2d\u65e0token, \u5c1d\u8bd5\u4eceParam\u4e2d\u83b7\u53d6");
            token = WebUtils.findParameterValue((ServletRequest)request, (String)UserType.USER.tokenKey());
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            logger.warn("Param\u4e2d\u65e0token, \u5c1d\u8bd5\u4eceCookie\u4e2d\u83b7\u53d6");
            Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)UserType.USER.tokenKey());
            if (tokenCookie != null) {
                token = tokenCookie.getValue();
            }
        }
        logger.warn("token = {}", (Object)token);
        return token;
    }
}

