/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.interceptor;

import com.xforceplus.tenant.security.core.context.ClientInfoHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.core.utils.RequestUtils;
import com.xforceplus.tenant.security.server.adapter.RequestTokenUtils;
import com.xforceplus.tenant.security.starter.core.UserInfoHolderUtils;
import com.xforceplus.tenant.security.token.decoder.JwtDecoder;
import com.xforceplus.tenant.security.token.domain.UserType;
import io.geewit.web.utils.WebRequestUtils;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class UserContextInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UserContextInterceptor.class);
    private ApplicationContext applicationContext;
    private boolean tokenDecode;
    private String secret;
    private String defaultUserInfoJson;

    public UserContextInterceptor(ApplicationContext applicationContext) {
        logger.info("tenant-security.UserContextInterceptor initializing...");
        this.applicationContext = applicationContext;
        this.tokenDecode = (Boolean)applicationContext.getEnvironment().getProperty("xforce.tenant.security.starter.token.decode.enable", Boolean.class, (Object)false);
        logger.info("tokenDecode: {}", (Object)this.tokenDecode);
        this.secret = applicationContext.getEnvironment().getProperty("xforce.tenant.security.jwt.secret", "my_sessionjw_tsecret_xdfdffdsdfdfs_fat");
        logger.info("secret: {}", (Object)this.secret);
        this.defaultUserInfoJson = applicationContext.getEnvironment().getProperty("xforce.tenant.security.starter.interceptors.default_user_info");
        logger.info("defaultUserInfoJson: {}", (Object)this.defaultUserInfoJson);
        logger.info("tenant-security.UserContextInterceptor initialized");
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String deCompressedUserInfo;
        String userinfo;
        if (handler instanceof ResourceHttpRequestHandler) {
            logger.debug("handler instanceof ResourceHttpRequestHandler");
            return true;
        }
        if (!(handler instanceof HandlerMethod)) {
            logger.debug("handler not instanceof HandlerMethod");
            return true;
        }
        boolean isStaticPage = RequestUtils.isStaticPage((String)request.getRequestURI());
        if (isStaticPage) {
            logger.debug("isStaticPage: true, return");
            return true;
        }
        if (logger.isDebugEnabled()) {
            Map headers = WebRequestUtils.getHeaders((HttpServletRequest)request, (String[])new String[]{UserType.USER.userinfoKey()});
            Enumeration userinfoHeaders = (Enumeration)headers.get(UserType.USER.userinfoKey());
            while (userinfoHeaders.hasMoreElements()) {
                logger.debug("all header.userinfos: {}", userinfoHeaders.nextElement());
            }
        }
        if (this.tokenDecode) {
            String token = RequestTokenUtils.getToken(request);
            if (StringUtils.isBlank((CharSequence)token)) {
                String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
                logger.warn("token isBlank, {}, return", (Object)message);
                return true;
            }
            Map claims = JwtUtils.decodeToken((String)token);
            String userId = "userid";
            if (!CollectionUtils.isEmpty((Map)claims) && Objects.equals(Objects.requireNonNull(claims).get("type"), UserType.APPID.value()) && claims.containsKey(userId)) {
                ClientInfoHolder.put((String)((String)claims.get(userId)));
                return true;
            }
            userinfo = JwtDecoder.parseUserInfoFromToken((String)token, (String)this.secret);
            logger.debug("userinfo from token: {}", (Object)userinfo);
        } else {
            userinfo = request.getHeader(UserType.USER.userinfoKey());
            logger.debug("userinfo from header: {}", (Object)userinfo);
        }
        HandlerMethod method = (HandlerMethod)handler;
        if (StringUtils.isEmpty((CharSequence)userinfo)) {
            if (StringUtils.isEmpty((CharSequence)this.defaultUserInfoJson)) {
                logger.debug("this.defaultUserInfoJson is empty, return");
                return true;
            }
            deCompressedUserInfo = this.defaultUserInfoJson;
            userinfo = CompressionUtils.encode((String)this.defaultUserInfoJson);
        } else {
            try {
                deCompressedUserInfo = CompressionUtils.decode((String)userinfo);
            }
            catch (Exception e) {
                logger.warn("\u53d1\u751f\u5f02\u5e38:{}, return", (Object)e.getMessage());
                return false;
            }
        }
        logger.debug("deCompressedUserInfo: {}", (Object)deCompressedUserInfo);
        try {
            if (StringUtils.isNotEmpty((CharSequence)deCompressedUserInfo)) {
                return UserInfoHolderUtils.setUserInfoHolder((ApplicationContext)this.applicationContext, (String)userinfo, (String)deCompressedUserInfo, (HandlerMethod)method);
            }
            logger.debug("deCompressedUserInfo == null, return");
            return true;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38:{}, return", (Object)e.getMessage());
            return false;
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserInfoHolder.clearContext();
        ClientInfoHolder.clear();
        logger.info("tenant-security.UserInfoHolder.clear...");
    }
}

