/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.server.config;

import com.xforceplus.tenant.security.client.config.TenantFeignConfiguration;
import com.xforceplus.tenant.security.server.interceptor.UserContextInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfigureAfter(value={TenantFeignConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Configuration(value="tenantUserInterceptorConfig")
@ConditionalOnExpression(value="${xforce.tenant.security.starter.interceptors.enable:true}")
public class TenantUserInterceptorConfig
implements WebMvcConfigurer,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantUserInterceptorConfig.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public TenantUserInterceptorConfig() {
        logger.info("tenant-security.TenantUserInterceptorConfig initialized");
    }

    private UserContextInterceptor userContextInterceptor() {
        return new UserContextInterceptor(this.applicationContext);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        logger.info("registry interceptor:UserContextInterceptor");
        registry.addInterceptor((HandlerInterceptor)this.userContextInterceptor()).order(2147482647);
    }
}

