package com.xforceplus.tenant.security.starter.webflux.config;

import com.xforceplus.tenant.security.starter.webflux.filter.TenantUserContextFilter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.*;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.config.WebFluxConfigurer;

/**
 * 自动配置spring webflux的WebFilter
 * @author       黄方
 * @since        2020/11/12
 */
@Slf4j
@ConditionalOnExpression("${xforce.tenant.security.starter.webflux.enable:true}")
@Configuration(value = "tenantUserFilterConfig")
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(WebFluxConfigurer.class)
@AutoConfigureAfter({ WebFluxAutoConfiguration.class })
public class TenantUserFilterConfig implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public TenantUserFilterConfig() {
        log.info("tenant-security.TenantUserContextFilter initialized");
    }

    @Bean
    @ConditionalOnMissingBean(TenantUserContextFilter.class)
    @ConditionalOnProperty(prefix = "xforce.tenant.security.starter.webflux", name = "enable", matchIfMissing = true)
    public TenantUserContextFilter tenantUserContextFilter() {
        log.info("starter init bean:TenantUserContextFilter");
        return new TenantUserContextFilter(this.applicationContext);
    }
}
