package com.xforceplus.tenant.security.starter.webflux.adapter;

import com.xforceplus.tenant.security.token.domain.UserType;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

import java.util.List;
import java.util.stream.Collectors;


/**
 * @author geewit
 */
@Slf4j
public class RequestTokenUtils {
    public static String getToken(ServerHttpRequest request) {

        List<String> tokens = request.getHeaders().get(UserType.USER.tokenKey());
        String token = getTokenFromList(tokens);
        if(token == null) {
            log.warn("Header中无token");
            tokens = request.getQueryParams().get(UserType.USER.tokenKey());
            token = getTokenFromList(tokens);
        }
        if(token == null) {
            log.warn("Param中无token");
            List<HttpCookie> cookies = request.getCookies().get(UserType.USER.tokenKey());
            if(cookies != null && !cookies.isEmpty()) {
                tokens = cookies.stream().map(HttpCookie::getValue).collect(Collectors.toList());
                token = getTokenFromList(tokens);
            }
        }
        if(token == null) {
            log.warn("Cookie中无token");
        }
        log.warn("token = {}", token);
        return token;
    }

    private static String getTokenFromList(List<String> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            return null;
        }
        String token = tokens.stream().filter(StringUtils::isNotBlank).findFirst().orElse(null);
        return token;
    }
}
