/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.starter.webflux.adapter;

import com.xforceplus.tenant.security.token.domain.UserType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class RequestTokenUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestTokenUtils.class);

    public static String getToken(ServerHttpRequest request) {
        List<String> tokens = request.getHeaders().get((Object)UserType.USER.tokenKey());
        String token = RequestTokenUtils.getTokenFromList(tokens);
        if (token == null) {
            logger.warn("Header\u4e2d\u65e0token");
            tokens = (List)request.getQueryParams().get((Object)UserType.USER.tokenKey());
            token = RequestTokenUtils.getTokenFromList(tokens);
        }
        if (token == null) {
            logger.warn("Param\u4e2d\u65e0token");
            List cookies = (List)request.getCookies().get((Object)UserType.USER.tokenKey());
            if (cookies != null && !cookies.isEmpty()) {
                tokens = cookies.stream().map(HttpCookie::getValue).collect(Collectors.toList());
                token = RequestTokenUtils.getTokenFromList(tokens);
            }
        }
        if (token == null) {
            logger.warn("Cookie\u4e2d\u65e0token");
        }
        logger.warn("token = {}", (Object)token);
        return token;
    }

    private static String getTokenFromList(List<String> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            return null;
        }
        String token = tokens.stream().filter(StringUtils::isNotBlank).findFirst().orElse(null);
        return token;
    }
}

