package com.xforceplus.tenant.security.starter.webflux.config;

import com.xforceplus.tenant.security.starter.webflux.filter.TenantUserContextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.*;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.config.WebFluxConfigurer;

/**
 * 自动配置spring webflux的WebFilter
 * @author:      黄方
 * @since :       2020/11/12
 */
@ConditionalOnExpression("${xforce.tenant.security.starter.webflux.enable:true}")
@Configuration(value = "tenantUserFilterConfig")
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(WebFluxConfigurer.class)
@AutoConfigureAfter({ WebFluxAutoConfiguration.class })
public class TenantUserFilterConfig implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantUserFilterConfig.class);

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.info("starter TenantUserFilterConfig loading");
        this.applicationContext = applicationContext;
    }

    public TenantUserFilterConfig() {
        logger.info("starter TenantUserContextFilter initialized");
    }

    @Bean
    @ConditionalOnMissingBean(TenantUserContextFilter.class)
    @ConditionalOnProperty(prefix = "xforce.tenant.security.starter.webflux", name = "enable", matchIfMissing = true)
    public TenantUserContextFilter tenantUserContextFilter() {
        logger.info("starter init bean:TenantUserContextFilter");
        return new TenantUserContextFilter(this.applicationContext);
    }
}
