/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.starter.webflux.config;

import com.xforceplus.tenant.security.starter.webflux.filter.TenantUserContextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@ConditionalOnExpression(value="${xforce.tenant.security.starter.webflux.enable:true}")
@Configuration(value="tenantUserFilterConfig")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={WebFluxConfigurer.class})
@AutoConfigureAfter(value={WebFluxAutoConfiguration.class})
public class TenantUserFilterConfig
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantUserFilterConfig.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public TenantUserFilterConfig() {
        logger.info("tenant-security.TenantUserContextFilter initialized");
    }

    @Bean
    @ConditionalOnMissingBean(value={TenantUserContextFilter.class})
    @ConditionalOnProperty(prefix="xforce.tenant.security.starter.webflux", name={"enable"}, matchIfMissing=true)
    public TenantUserContextFilter tenantUserContextFilter() {
        logger.info("starter init bean:TenantUserContextFilter");
        return new TenantUserContextFilter(this.applicationContext);
    }
}

